/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.jdbc;

import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import nom.bdezonia.zorbage.tuple.Tuple2;
import nom.bdezonia.zorbage.type.ctor.Allocatable;

public abstract class AbstractJdbcStorage<U extends Allocatable<U>> {
    protected final U type;
    protected final long size;
    protected final String tableName;
    protected final Connection conn;

    protected AbstractJdbcStorage(long size, U type, Connection conn) {
        if (size < 0L) {
            throw new IllegalArgumentException("jdbc storage size must be >= 0");
        }
        this.size = size;
        this.type = (Allocatable)type.allocate();
        this.conn = conn;
        this.tableName = this.newTableName(conn);
    }

    public long size() {
        return this.size;
    }

    public void cleanup() {
        try {
            Statement statement = this.conn.createStatement();
            StringBuilder sb = new StringBuilder();
            sb.append("DROP TABLE ");
            sb.append(this.tableName);
            sb.append(';');
            String sql = sb.toString();
            statement.execute(sql);
            statement.close();
        }
        catch (SQLException e) {
            System.out.println(e);
        }
    }

    protected void createTable(Connection conn, String tableName, String sqlType, int count, long size) {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ");
        sb.append(tableName);
        sb.append("(ID bigint NOT NULL, ");
        for (int i = 0; i < count; ++i) {
            sb.append(" v");
            sb.append(i);
            sb.append(' ');
            sb.append(sqlType);
            sb.append(" NOT NULL,");
        }
        sb.append(" PRIMARY KEY (ID));");
        String sql = sb.toString();
        Statement statement = null;
        try {
            statement = conn.createStatement();
            statement.execute(sql);
            statement.close();
        }
        catch (SQLException e) {
            System.out.println(e);
        }
    }

    protected void zeroFill(int valueCount) {
        long MAX = 500L;
        try {
            long num;
            Statement statement = this.conn.createStatement();
            for (long i = 0L; i < this.size; i += num) {
                num = this.size - i < 500L ? this.size - i : 500L;
                String sql = this.makeInsertZeroesStatement(i, num, valueCount);
                statement.execute(sql);
            }
            statement.close();
        }
        catch (SQLException e) {
            System.out.println(e);
        }
    }

    protected String makeInsertZeroesStatement(long offset, long count, int valueCount) {
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ");
        sb.append(this.tableName);
        sb.append(" VALUES ");
        for (long c = 0L; c < count; ++c) {
            sb.append('(');
            sb.append(offset + c);
            for (int i = 0; i < valueCount; ++i) {
                sb.append(',');
                sb.append('0');
            }
            sb.append(')');
            if (c == count - 1L) continue;
            sb.append(',');
        }
        sb.append(';');
        return sb.toString();
    }

    protected void copyTableToTable(Connection conn, String fromTable, String toTable) {
        StringBuilder sb2 = new StringBuilder();
        sb2.append("TRUNCATE TABLE ");
        sb2.append(toTable);
        sb2.append(';');
        String sql = sb2.toString();
        try {
            Statement statement = conn.createStatement();
            statement.execute(sql);
            statement.close();
        }
        catch (SQLException e) {
            System.out.println(e.getMessage());
        }
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ");
        sb.append(toTable);
        sb.append(" SELECT * FROM ");
        sb.append(fromTable);
        sb.append(" WHERE 1 = 1;");
        sql = sb.toString();
        try {
            Statement statement = conn.createStatement();
            statement.execute(sql);
            statement.close();
        }
        catch (SQLException e) {
            System.out.println(e.getMessage());
        }
    }

    protected String newTableName(Connection conn) {
        String name;
        ThreadLocalRandom rng = ThreadLocalRandom.current();
        do {
            StringBuilder sb = new StringBuilder();
            sb.append("t_");
            sb.append(this.randomChar(rng));
            sb.append(this.randomChar(rng));
            sb.append(this.randomChar(rng));
            sb.append(this.randomChar(rng));
            sb.append(this.randomChar(rng));
            sb.append(this.randomChar(rng));
            sb.append(this.randomChar(rng));
            sb.append(this.randomChar(rng));
            sb.append(this.randomChar(rng));
            StringBuilder sb2 = new StringBuilder();
            sb2.append("SELECT 1 FROM ");
            sb2.append(sb.toString());
            sb2.append(" LIMIT 1;");
            String sql = sb2.toString();
            Statement statement = null;
            name = null;
            try {
                statement = conn.createStatement();
                statement.executeQuery(sql);
            }
            catch (SQLException e) {
                name = sb.toString();
            }
            try {
                if (statement == null) continue;
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        } while (name == null);
        return name;
    }

    protected Tuple2<Statement, ResultSet> getHelper(long index, int count) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        for (int i = 0; i < count; ++i) {
            sb.append('v');
            sb.append(i);
            if (i == count - 1) continue;
            sb.append(',');
        }
        sb.append(" FROM ");
        sb.append(this.tableName);
        sb.append(" WHERE id = ");
        sb.append(index);
        sb.append(';');
        String sql = sb.toString();
        Statement statement = null;
        try {
            statement = this.conn.createStatement();
            ResultSet result = statement.executeQuery(sql);
            return new Tuple2<Statement, ResultSet>(statement, result);
        }
        catch (SQLException e) {
            return new Tuple2<Object, Object>(null, null);
        }
    }

    protected void setHelper(long index, Object array) {
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE ");
        sb.append(this.tableName);
        sb.append(" SET ");
        for (int i = 0; i < Array.getLength(array); ++i) {
            sb.append('v');
            sb.append(i);
            sb.append('=');
            sb.append(Array.get(array, i).toString());
            if (i == Array.getLength(array) - 1) continue;
            sb.append(',');
        }
        sb.append(" WHERE id = ");
        sb.append(index);
        sb.append(';');
        String sql = sb.toString();
        try {
            Statement statement = this.conn.createStatement();
            statement.executeUpdate(sql);
            statement.close();
        }
        catch (SQLException e) {
            System.out.println(e.getMessage());
        }
    }

    private char randomChar(Random rng) {
        return (char)(97 + rng.nextInt(26));
    }
}

