/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.jdbc;

import java.sql.Connection;
import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.storage.coder.BooleanCoder;
import nom.bdezonia.zorbage.type.storage.coder.ByteCoder;
import nom.bdezonia.zorbage.type.storage.coder.DoubleCoder;
import nom.bdezonia.zorbage.type.storage.coder.FloatCoder;
import nom.bdezonia.zorbage.type.storage.coder.IntCoder;
import nom.bdezonia.zorbage.type.storage.coder.LongCoder;
import nom.bdezonia.zorbage.type.storage.coder.ShortCoder;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;
import nom.bdezonia.zorbage.type.storage.jdbc.JdbcStorageBoolean;
import nom.bdezonia.zorbage.type.storage.jdbc.JdbcStorageFloat32;
import nom.bdezonia.zorbage.type.storage.jdbc.JdbcStorageFloat64;
import nom.bdezonia.zorbage.type.storage.jdbc.JdbcStorageSignedInt16;
import nom.bdezonia.zorbage.type.storage.jdbc.JdbcStorageSignedInt32;
import nom.bdezonia.zorbage.type.storage.jdbc.JdbcStorageSignedInt64;
import nom.bdezonia.zorbage.type.storage.jdbc.JdbcStorageSignedInt8;

public class JdbcStorage {
    public static <U extends Allocatable<U>> IndexedDataSource<U> allocate(Connection conn, long size, U type) {
        if (type instanceof DoubleCoder) {
            return new JdbcStorageFloat64<DoubleCoder>(size, (DoubleCoder)((Object)type), conn);
        }
        if (type instanceof FloatCoder) {
            return new JdbcStorageFloat32<FloatCoder>(size, (FloatCoder)((Object)type), conn);
        }
        if (type instanceof LongCoder) {
            return new JdbcStorageSignedInt64<LongCoder>(size, (LongCoder)((Object)type), conn);
        }
        if (type instanceof IntCoder) {
            return new JdbcStorageSignedInt32<IntCoder>(size, (IntCoder)((Object)type), conn);
        }
        if (type instanceof ShortCoder) {
            return new JdbcStorageSignedInt16<ShortCoder>(size, (ShortCoder)((Object)type), conn);
        }
        if (type instanceof BooleanCoder) {
            return new JdbcStorageBoolean<BooleanCoder>(size, (BooleanCoder)((Object)type), conn);
        }
        if (type instanceof ByteCoder) {
            return new JdbcStorageSignedInt8<ByteCoder>(size, (ByteCoder)((Object)type), conn);
        }
        throw new IllegalArgumentException("Unsupported type in JdbcStorage");
    }
}

