/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import nom.bdezonia.zorbage.tuple.Tuple2;
import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.storage.coder.BooleanCoder;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;
import nom.bdezonia.zorbage.type.storage.jdbc.AbstractJdbcStorage;

public class JdbcStorageBoolean<U extends BooleanCoder & Allocatable<U>>
extends AbstractJdbcStorage<U>
implements IndexedDataSource<U>,
Allocatable<JdbcStorageBoolean<U>> {
    private final ThreadLocal<boolean[]> tmpSpace = new ThreadLocal<boolean[]>(){

        @Override
        protected boolean[] initialValue() {
            return new boolean[((BooleanCoder)((Object)JdbcStorageBoolean.this.type)).booleanCount()];
        }
    };

    public JdbcStorageBoolean(long size, U type, Connection conn) {
        super(size, (Allocatable)type, conn);
        this.createTable(conn, this.tableName, "BIT", type.booleanCount(), size);
        this.zeroFill(type.booleanCount());
    }

    public JdbcStorageBoolean(JdbcStorageBoolean<U> other) {
        super(other.size, other.type, other.conn);
        this.createTable(this.conn, this.tableName, "BIT", ((BooleanCoder)((Object)this.type)).booleanCount(), this.size);
        this.copyTableToTable(this.conn, other.tableName, this.tableName);
    }

    @Override
    public JdbcStorageBoolean<U> duplicate() {
        return new JdbcStorageBoolean<U>(this);
    }

    @Override
    public void set(long index, U value) {
        if (index < 0L || index >= this.size) {
            throw new IllegalArgumentException("index out of bounds");
        }
        boolean[] arr = this.tmpSpace.get();
        value.toBooleanArray(arr, 0);
        this.setHelper(index, arr);
    }

    @Override
    public void get(long index, U value) {
        if (index < 0L || index >= this.size) {
            throw new IllegalArgumentException("index out of bounds");
        }
        Tuple2<Statement, ResultSet> result = this.getHelper(index, ((BooleanCoder)((Object)this.type)).booleanCount());
        boolean[] arr = this.tmpSpace.get();
        try {
            result.b().next();
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = result.b().getBoolean(i + 1);
            }
            value.fromBooleanArray(arr, 0);
            result.a().close();
        }
        catch (SQLException e) {
            System.out.println(e.getMessage());
        }
    }

    @Override
    public JdbcStorageBoolean<U> allocate() {
        return new JdbcStorageBoolean<BooleanCoder>(this.size(), (BooleanCoder)((Object)this.type), this.conn);
    }

    @Override
    public StorageConstruction storageType() {
        return StorageConstruction.MEM_VIRTUAL;
    }
}

