/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import nom.bdezonia.zorbage.tuple.Tuple2;
import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.storage.coder.FloatCoder;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;
import nom.bdezonia.zorbage.type.storage.jdbc.AbstractJdbcStorage;

public class JdbcStorageFloat32<U extends FloatCoder & Allocatable<U>>
extends AbstractJdbcStorage<U>
implements IndexedDataSource<U>,
Allocatable<JdbcStorageFloat32<U>> {
    private final ThreadLocal<float[]> tmpSpace = new ThreadLocal<float[]>(){

        @Override
        protected float[] initialValue() {
            return new float[((FloatCoder)((Object)JdbcStorageFloat32.this.type)).floatCount()];
        }
    };

    public JdbcStorageFloat32(long size, U type, Connection conn) {
        super(size, (Allocatable)type, conn);
        this.createTable(conn, this.tableName, "REAL", type.floatCount(), size);
        this.zeroFill(type.floatCount());
    }

    public JdbcStorageFloat32(JdbcStorageFloat32<U> other) {
        super(other.size, other.type, other.conn);
        this.createTable(this.conn, this.tableName, "REAL", ((FloatCoder)((Object)this.type)).floatCount(), this.size);
        this.copyTableToTable(this.conn, other.tableName, this.tableName);
    }

    @Override
    public JdbcStorageFloat32<U> duplicate() {
        return new JdbcStorageFloat32<U>(this);
    }

    @Override
    public void set(long index, U value) {
        if (index < 0L || index >= this.size) {
            throw new IllegalArgumentException("index out of bounds");
        }
        float[] arr = this.tmpSpace.get();
        value.toFloatArray(arr, 0);
        this.setHelper(index, arr);
    }

    @Override
    public void get(long index, U value) {
        if (index < 0L || index >= this.size) {
            throw new IllegalArgumentException("index out of bounds");
        }
        Tuple2<Statement, ResultSet> result = this.getHelper(index, ((FloatCoder)((Object)this.type)).floatCount());
        float[] arr = this.tmpSpace.get();
        try {
            result.b().next();
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = result.b().getFloat(i + 1);
            }
            value.fromFloatArray(arr, 0);
            result.a().close();
        }
        catch (SQLException e) {
            System.out.println(e.getMessage());
        }
    }

    @Override
    public JdbcStorageFloat32<U> allocate() {
        return new JdbcStorageFloat32<FloatCoder>(this.size(), (FloatCoder)((Object)this.type), this.conn);
    }

    @Override
    public StorageConstruction storageType() {
        return StorageConstruction.MEM_VIRTUAL;
    }
}

