/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import nom.bdezonia.zorbage.tuple.Tuple2;
import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.storage.coder.DoubleCoder;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;
import nom.bdezonia.zorbage.type.storage.jdbc.AbstractJdbcStorage;

public class JdbcStorageFloat64<U extends DoubleCoder & Allocatable<U>>
extends AbstractJdbcStorage<U>
implements IndexedDataSource<U>,
Allocatable<JdbcStorageFloat64<U>> {
    private final ThreadLocal<double[]> tmpSpace = new ThreadLocal<double[]>(){

        @Override
        protected double[] initialValue() {
            return new double[((DoubleCoder)((Object)JdbcStorageFloat64.this.type)).doubleCount()];
        }
    };

    public JdbcStorageFloat64(long size, U type, Connection conn) {
        super(size, (Allocatable)type, conn);
        this.createTable(conn, this.tableName, "DOUBLE", type.doubleCount(), size);
        this.zeroFill(type.doubleCount());
    }

    public JdbcStorageFloat64(JdbcStorageFloat64<U> other) {
        super(other.size, other.type, other.conn);
        this.createTable(this.conn, this.tableName, "DOUBLE", ((DoubleCoder)((Object)this.type)).doubleCount(), this.size);
        this.copyTableToTable(this.conn, other.tableName, this.tableName);
    }

    @Override
    public JdbcStorageFloat64<U> duplicate() {
        return new JdbcStorageFloat64<U>(this);
    }

    @Override
    public void set(long index, U value) {
        if (index < 0L || index >= this.size) {
            throw new IllegalArgumentException("index out of bounds");
        }
        double[] arr = this.tmpSpace.get();
        value.toDoubleArray(arr, 0);
        this.setHelper(index, arr);
    }

    @Override
    public void get(long index, U value) {
        if (index < 0L || index >= this.size) {
            throw new IllegalArgumentException("index out of bounds");
        }
        Tuple2<Statement, ResultSet> result = this.getHelper(index, ((DoubleCoder)((Object)this.type)).doubleCount());
        double[] arr = this.tmpSpace.get();
        try {
            result.b().next();
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = result.b().getDouble(i + 1);
            }
            value.fromDoubleArray(arr, 0);
            result.a().close();
        }
        catch (SQLException e) {
            System.out.println(e.getMessage());
        }
    }

    @Override
    public JdbcStorageFloat64<U> allocate() {
        return new JdbcStorageFloat64<DoubleCoder>(this.size(), (DoubleCoder)((Object)this.type), this.conn);
    }

    @Override
    public StorageConstruction storageType() {
        return StorageConstruction.MEM_VIRTUAL;
    }
}

