/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import nom.bdezonia.zorbage.tuple.Tuple2;
import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.storage.coder.ShortCoder;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;
import nom.bdezonia.zorbage.type.storage.jdbc.AbstractJdbcStorage;

public class JdbcStorageSignedInt16<U extends ShortCoder & Allocatable<U>>
extends AbstractJdbcStorage<U>
implements IndexedDataSource<U>,
Allocatable<JdbcStorageSignedInt16<U>> {
    private final ThreadLocal<short[]> tmpSpace = new ThreadLocal<short[]>(){

        @Override
        protected short[] initialValue() {
            return new short[((ShortCoder)((Object)JdbcStorageSignedInt16.this.type)).shortCount()];
        }
    };

    public JdbcStorageSignedInt16(long size, U type, Connection conn) {
        super(size, (Allocatable)type, conn);
        this.createTable(conn, this.tableName, "SMALLINT", type.shortCount(), size);
        this.zeroFill(type.shortCount());
    }

    public JdbcStorageSignedInt16(JdbcStorageSignedInt16<U> other) {
        super(other.size, other.type, other.conn);
        this.createTable(this.conn, this.tableName, "SMALLINT", ((ShortCoder)((Object)this.type)).shortCount(), this.size);
        this.copyTableToTable(this.conn, other.tableName, this.tableName);
    }

    @Override
    public JdbcStorageSignedInt16<U> duplicate() {
        return new JdbcStorageSignedInt16<U>(this);
    }

    @Override
    public void set(long index, U value) {
        if (index < 0L || index >= this.size) {
            throw new IllegalArgumentException("index out of bounds");
        }
        short[] arr = this.tmpSpace.get();
        value.toShortArray(arr, 0);
        this.setHelper(index, arr);
    }

    @Override
    public void get(long index, U value) {
        if (index < 0L || index >= this.size) {
            throw new IllegalArgumentException("index out of bounds");
        }
        Tuple2<Statement, ResultSet> result = this.getHelper(index, ((ShortCoder)((Object)this.type)).shortCount());
        short[] arr = this.tmpSpace.get();
        try {
            result.b().next();
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = result.b().getShort(i + 1);
            }
            value.fromShortArray(arr, 0);
            result.a().close();
        }
        catch (SQLException e) {
            System.out.println(e.getMessage());
        }
    }

    @Override
    public JdbcStorageSignedInt16<U> allocate() {
        return new JdbcStorageSignedInt16<ShortCoder>(this.size(), (ShortCoder)((Object)this.type), this.conn);
    }

    @Override
    public StorageConstruction storageType() {
        return StorageConstruction.MEM_VIRTUAL;
    }
}

