/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import nom.bdezonia.zorbage.tuple.Tuple2;
import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.storage.coder.IntCoder;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;
import nom.bdezonia.zorbage.type.storage.jdbc.AbstractJdbcStorage;

public class JdbcStorageSignedInt32<U extends IntCoder & Allocatable<U>>
extends AbstractJdbcStorage<U>
implements IndexedDataSource<U>,
Allocatable<JdbcStorageSignedInt32<U>> {
    private final ThreadLocal<int[]> tmpSpace = new ThreadLocal<int[]>(){

        @Override
        protected int[] initialValue() {
            return new int[((IntCoder)((Object)JdbcStorageSignedInt32.this.type)).intCount()];
        }
    };

    public JdbcStorageSignedInt32(long size, U type, Connection conn) {
        super(size, (Allocatable)type, conn);
        this.createTable(conn, this.tableName, "INTEGER", type.intCount(), size);
        this.zeroFill(type.intCount());
    }

    public JdbcStorageSignedInt32(JdbcStorageSignedInt32<U> other) {
        super(other.size, other.type, other.conn);
        this.createTable(this.conn, this.tableName, "INTEGER", ((IntCoder)((Object)this.type)).intCount(), this.size);
        this.copyTableToTable(this.conn, other.tableName, this.tableName);
    }

    @Override
    public JdbcStorageSignedInt32<U> duplicate() {
        return new JdbcStorageSignedInt32<U>(this);
    }

    @Override
    public void set(long index, U value) {
        if (index < 0L || index >= this.size) {
            throw new IllegalArgumentException("index out of bounds");
        }
        int[] arr = this.tmpSpace.get();
        value.toIntArray(arr, 0);
        this.setHelper(index, arr);
    }

    @Override
    public void get(long index, U value) {
        if (index < 0L || index >= this.size) {
            throw new IllegalArgumentException("index out of bounds");
        }
        Tuple2<Statement, ResultSet> result = this.getHelper(index, ((IntCoder)((Object)this.type)).intCount());
        int[] arr = this.tmpSpace.get();
        try {
            result.b().next();
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = result.b().getInt(i + 1);
            }
            value.fromIntArray(arr, 0);
            result.a().close();
        }
        catch (SQLException e) {
            System.out.println(e.getMessage());
        }
    }

    @Override
    public JdbcStorageSignedInt32<U> allocate() {
        return new JdbcStorageSignedInt32<IntCoder>(this.size(), (IntCoder)((Object)this.type), this.conn);
    }

    @Override
    public StorageConstruction storageType() {
        return StorageConstruction.MEM_VIRTUAL;
    }
}

