/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import nom.bdezonia.zorbage.tuple.Tuple2;
import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.storage.coder.LongCoder;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;
import nom.bdezonia.zorbage.type.storage.jdbc.AbstractJdbcStorage;

public class JdbcStorageSignedInt64<U extends LongCoder & Allocatable<U>>
extends AbstractJdbcStorage<U>
implements IndexedDataSource<U>,
Allocatable<JdbcStorageSignedInt64<U>> {
    private final ThreadLocal<long[]> tmpSpace = new ThreadLocal<long[]>(){

        @Override
        protected long[] initialValue() {
            return new long[((LongCoder)((Object)JdbcStorageSignedInt64.this.type)).longCount()];
        }
    };

    public JdbcStorageSignedInt64(long size, U type, Connection conn) {
        super(size, (Allocatable)type, conn);
        this.createTable(conn, this.tableName, "BIGINT", type.longCount(), size);
        this.zeroFill(type.longCount());
    }

    public JdbcStorageSignedInt64(JdbcStorageSignedInt64<U> other) {
        super(other.size, other.type, other.conn);
        this.createTable(this.conn, this.tableName, "BIGINT", ((LongCoder)((Object)this.type)).longCount(), this.size);
        this.copyTableToTable(this.conn, other.tableName, this.tableName);
    }

    @Override
    public JdbcStorageSignedInt64<U> duplicate() {
        return new JdbcStorageSignedInt64<U>(this);
    }

    @Override
    public void set(long index, U value) {
        if (index < 0L || index >= this.size) {
            throw new IllegalArgumentException("index out of bounds");
        }
        long[] arr = this.tmpSpace.get();
        value.toLongArray(arr, 0);
        this.setHelper(index, arr);
    }

    @Override
    public void get(long index, U value) {
        if (index < 0L || index >= this.size) {
            throw new IllegalArgumentException("index out of bounds");
        }
        Tuple2<Statement, ResultSet> result = this.getHelper(index, ((LongCoder)((Object)this.type)).longCount());
        long[] arr = this.tmpSpace.get();
        try {
            result.b().next();
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = result.b().getLong(i + 1);
            }
            value.fromLongArray(arr, 0);
            result.a().close();
        }
        catch (SQLException e) {
            System.out.println(e.getMessage());
        }
    }

    @Override
    public JdbcStorageSignedInt64<U> allocate() {
        return new JdbcStorageSignedInt64<LongCoder>(this.size(), (LongCoder)((Object)this.type), this.conn);
    }

    @Override
    public StorageConstruction storageType() {
        return StorageConstruction.MEM_VIRTUAL;
    }
}

