/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import nom.bdezonia.zorbage.tuple.Tuple2;
import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.storage.coder.ByteCoder;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;
import nom.bdezonia.zorbage.type.storage.jdbc.AbstractJdbcStorage;

public class JdbcStorageSignedInt8<U extends ByteCoder & Allocatable<U>>
extends AbstractJdbcStorage<U>
implements IndexedDataSource<U>,
Allocatable<JdbcStorageSignedInt8<U>> {
    private final ThreadLocal<byte[]> tmpSpace = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[((ByteCoder)((Object)JdbcStorageSignedInt8.this.type)).byteCount()];
        }
    };

    public JdbcStorageSignedInt8(long size, U type, Connection conn) {
        super(size, (Allocatable)type, conn);
        this.createTable(conn, this.tableName, "TINYINT", type.byteCount(), size);
        this.zeroFill(type.byteCount());
    }

    public JdbcStorageSignedInt8(JdbcStorageSignedInt8<U> other) {
        super(other.size, other.type, other.conn);
        this.createTable(this.conn, this.tableName, "TINYINT", ((ByteCoder)((Object)this.type)).byteCount(), this.size);
        this.copyTableToTable(this.conn, other.tableName, this.tableName);
    }

    @Override
    public JdbcStorageSignedInt8<U> duplicate() {
        return new JdbcStorageSignedInt8<U>(this);
    }

    @Override
    public void set(long index, U value) {
        if (index < 0L || index >= this.size) {
            throw new IllegalArgumentException("index out of bounds");
        }
        byte[] arr = this.tmpSpace.get();
        value.toByteArray(arr, 0);
        this.setHelper(index, arr);
    }

    @Override
    public void get(long index, U value) {
        if (index < 0L || index >= this.size) {
            throw new IllegalArgumentException("index out of bounds");
        }
        Tuple2<Statement, ResultSet> result = this.getHelper(index, ((ByteCoder)((Object)this.type)).byteCount());
        byte[] arr = this.tmpSpace.get();
        try {
            result.b().next();
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = result.b().getByte(i + 1);
            }
            value.fromByteArray(arr, 0);
            result.a().close();
        }
        catch (SQLException e) {
            System.out.println(e.getMessage());
        }
    }

    @Override
    public JdbcStorageSignedInt8<U> allocate() {
        return new JdbcStorageSignedInt8<ByteCoder>(this.size(), (ByteCoder)((Object)this.type), this.conn);
    }

    @Override
    public StorageConstruction storageType() {
        return StorageConstruction.MEM_VIRTUAL;
    }
}

