/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.sparse;

public class RedBlackTree<T> {
    Node root;
    Node nil;

    private Node nilNode() {
        Node nil = new Node();
        nil.color = Color.BLACK;
        nil.p = nil;
        nil.left = nil;
        nil.right = nil;
        nil.key = Long.MIN_VALUE;
        nil.value = null;
        return nil;
    }

    RedBlackTree() {
        this.root = this.nil = this.nilNode();
    }

    Node findElement(long i) {
        Node n = this.root;
        while (n != this.nil) {
            if (n.key == i) {
                return n;
            }
            if (i < n.key) {
                n = n.left;
                continue;
            }
            n = n.right;
        }
        return this.nil;
    }

    void leftRotate(Node x) {
        if (x == this.nil) {
            return;
        }
        Node y = x.right;
        x.right = y.left;
        if (y.left != this.nil) {
            y.left.p = x;
        }
        y.p = x.p;
        if (x.p == this.nil) {
            this.root = y;
        } else if (x == x.p.left) {
            x.p.left = y;
        } else {
            x.p.right = y;
        }
        y.left = x;
        x.p = y;
    }

    void rightRotate(Node x) {
        if (x == this.nil) {
            return;
        }
        Node y = x.left;
        x.left = y.right;
        if (y.right != this.nil) {
            y.right.p = x;
        }
        y.p = x.p;
        if (x.p == this.nil) {
            this.root = y;
        } else if (x == x.p.right) {
            x.p.right = y;
        } else {
            x.p.left = y;
        }
        y.right = x;
        x.p = y;
    }

    void insert(Node z) {
        Node y = this.nil;
        Node x = this.root;
        while (x != this.nil) {
            y = x;
            if (z.key < x.key) {
                x = x.left;
                continue;
            }
            x = x.right;
        }
        z.p = y;
        if (y == this.nil) {
            this.root = z;
        } else if (z.key < y.key) {
            y.left = z;
        } else {
            y.right = z;
        }
        z.left = this.nil;
        z.right = this.nil;
        z.color = Color.RED;
        this.insertFixup(z);
    }

    void insertFixup(Node z) {
        while (z.p.color == Color.RED) {
            Node y;
            if (z.p == z.p.p.left) {
                y = z.p.p.right;
                if (y.color == Color.RED) {
                    z.p.color = Color.BLACK;
                    y.color = Color.BLACK;
                    z.p.p.color = Color.RED;
                    z = z.p.p;
                    continue;
                }
                if (z == z.p.right) {
                    z = z.p;
                    this.leftRotate(z);
                }
                z.p.color = Color.BLACK;
                z.p.p.color = Color.RED;
                this.rightRotate(z.p.p);
                continue;
            }
            y = z.p.p.left;
            if (y.color == Color.RED) {
                z.p.color = Color.BLACK;
                y.color = Color.BLACK;
                z.p.p.color = Color.RED;
                z = z.p.p;
                continue;
            }
            if (z == z.p.left) {
                z = z.p;
                this.rightRotate(z);
            }
            z.p.color = Color.BLACK;
            z.p.p.color = Color.RED;
            this.leftRotate(z.p.p);
        }
    }

    void transplant(Node u, Node v) {
        if (u.p == this.nil) {
            this.root = v;
        } else if (u == u.p.left) {
            u.p.left = v;
        } else {
            u.p.right = v;
        }
        v.p = u.p;
    }

    void delete(Node z) {
        Node x;
        Node y = z;
        Color yOrigColor = y.color;
        if (z.left == this.nil) {
            x = z.right;
            this.transplant(z, z.right);
        } else if (z.right == this.nil) {
            x = z.left;
            this.transplant(z, z.left);
        } else {
            y = this.treeMinimum(z.right);
            yOrigColor = y.color;
            x = y.right;
            if (y.p == z) {
                x.p = y;
            } else {
                this.transplant(y, y.right);
                y.right = z.right;
                y.right.p = y;
            }
            this.transplant(z, y);
            y.left = z.left;
            y.left.p = y;
            y.color = z.color;
        }
        if (yOrigColor == Color.BLACK) {
            this.deleteFixup(x);
        }
    }

    void deleteFixup(Node x) {
        while (x != this.root && x.color == Color.BLACK) {
            Node w;
            if (x == x.p.left) {
                w = x.p.right;
                if (w.color == Color.RED) {
                    w.color = Color.BLACK;
                    x.p.color = Color.RED;
                    this.leftRotate(x.p);
                    w = x.p.right;
                }
                if (w.left.color == Color.BLACK && w.right.color == Color.BLACK) {
                    w.color = Color.RED;
                    x = x.p;
                    continue;
                }
                if (w.right.color == Color.BLACK) {
                    w.left.color = Color.BLACK;
                    w.color = Color.RED;
                    this.rightRotate(w);
                    w = x.p.right;
                }
                w.color = x.p.color;
                x.p.color = Color.BLACK;
                w.right.color = Color.BLACK;
                this.leftRotate(x.p);
                x = this.root;
                continue;
            }
            w = x.p.left;
            if (w.color == Color.RED) {
                w.color = Color.BLACK;
                x.p.color = Color.RED;
                this.rightRotate(x.p);
                w = x.p.left;
            }
            if (w.right.color == Color.BLACK && w.left.color == Color.BLACK) {
                w.color = Color.RED;
                x = x.p;
                continue;
            }
            if (w.left.color == Color.BLACK) {
                w.right.color = Color.BLACK;
                w.color = Color.RED;
                this.leftRotate(w);
                w = x.p.left;
            }
            w.color = x.p.color;
            x.p.color = Color.BLACK;
            w.left.color = Color.BLACK;
            this.rightRotate(x.p);
            x = this.root;
        }
        x.color = Color.BLACK;
    }

    Node treeMinimum(Node x) {
        if (x == this.nil) {
            return this.nil;
        }
        while (x.left != this.nil) {
            x = x.left;
        }
        return x;
    }

    class Node {
        Color color;
        Node p;
        Node left;
        Node right;
        long key;
        T value;

        Node() {
        }
    }

    static enum Color {
        RED,
        BLACK;

    }
}

