/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.sparse;

import nom.bdezonia.zorbage.type.storage.coder.BigDecimalCoder;
import nom.bdezonia.zorbage.type.storage.coder.BigIntegerCoder;
import nom.bdezonia.zorbage.type.storage.coder.BooleanCoder;
import nom.bdezonia.zorbage.type.storage.coder.ByteCoder;
import nom.bdezonia.zorbage.type.storage.coder.DoubleCoder;
import nom.bdezonia.zorbage.type.storage.coder.FloatCoder;
import nom.bdezonia.zorbage.type.storage.coder.IntCoder;
import nom.bdezonia.zorbage.type.storage.coder.LongCoder;
import nom.bdezonia.zorbage.type.storage.coder.ShortCoder;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;
import nom.bdezonia.zorbage.type.storage.sparse.SparseStorageBigDecimal;
import nom.bdezonia.zorbage.type.storage.sparse.SparseStorageBigInteger;
import nom.bdezonia.zorbage.type.storage.sparse.SparseStorageBoolean;
import nom.bdezonia.zorbage.type.storage.sparse.SparseStorageFloat32;
import nom.bdezonia.zorbage.type.storage.sparse.SparseStorageFloat64;
import nom.bdezonia.zorbage.type.storage.sparse.SparseStorageSignedInt16;
import nom.bdezonia.zorbage.type.storage.sparse.SparseStorageSignedInt32;
import nom.bdezonia.zorbage.type.storage.sparse.SparseStorageSignedInt64;
import nom.bdezonia.zorbage.type.storage.sparse.SparseStorageSignedInt8;

public class SparseStorage {
    public static <U> IndexedDataSource<U> allocate(long size, U type) {
        if (type instanceof DoubleCoder) {
            return new SparseStorageFloat64<DoubleCoder>(size, (DoubleCoder)type);
        }
        if (type instanceof FloatCoder) {
            return new SparseStorageFloat32<FloatCoder>(size, (FloatCoder)type);
        }
        if (type instanceof LongCoder) {
            return new SparseStorageSignedInt64<LongCoder>(size, (LongCoder)type);
        }
        if (type instanceof IntCoder) {
            return new SparseStorageSignedInt32<IntCoder>(size, (IntCoder)type);
        }
        if (type instanceof ShortCoder) {
            return new SparseStorageSignedInt16<ShortCoder>(size, (ShortCoder)type);
        }
        if (type instanceof BooleanCoder) {
            return new SparseStorageBoolean<BooleanCoder>(size, (BooleanCoder)type);
        }
        if (type instanceof BigIntegerCoder) {
            return new SparseStorageBigInteger<BigIntegerCoder>(size, (BigIntegerCoder)type);
        }
        if (type instanceof BigDecimalCoder) {
            return new SparseStorageBigDecimal<BigDecimalCoder>(size, (BigDecimalCoder)type);
        }
        if (type instanceof ByteCoder) {
            return new SparseStorageSignedInt8<ByteCoder>(size, (ByteCoder)type);
        }
        throw new IllegalArgumentException("Unsupported type in SparseStorage");
    }
}

