/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.sparse;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Stack;
import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.storage.coder.BigDecimalCoder;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;
import nom.bdezonia.zorbage.type.storage.sparse.RedBlackTree;

public class SparseStorageBigDecimal<U extends BigDecimalCoder & Allocatable<U>>
implements IndexedDataSource<U>,
Allocatable<SparseStorageBigDecimal<U>> {
    private final RedBlackTree<BigDecimal[]> data;
    private final long numElements;
    private final BigDecimal[] zero;
    private final BigDecimal[] tmp;
    private final U type;

    public SparseStorageBigDecimal(long numElements, U type) {
        this.numElements = numElements;
        this.type = (BigDecimalCoder)((Allocatable)type).allocate();
        this.zero = new BigDecimal[type.bigDecimalCount()];
        this.tmp = new BigDecimal[type.bigDecimalCount()];
        this.data = new RedBlackTree();
        for (int i = 0; i < type.bigDecimalCount(); ++i) {
            this.zero[i] = BigDecimal.ZERO;
            this.tmp[i] = BigDecimal.ZERO;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SparseStorageBigDecimal<U> duplicate() {
        SparseStorageBigDecimal sparseStorageBigDecimal = this;
        synchronized (sparseStorageBigDecimal) {
            SparseStorageBigDecimal<U> list = new SparseStorageBigDecimal<U>(this.numElements, this.type);
            Stack<RedBlackTree.Node> nodes = new Stack<RedBlackTree.Node>();
            if (this.data.root != this.data.nil) {
                nodes.push(this.data.root);
                while (!nodes.isEmpty()) {
                    RedBlackTree.Node n = (RedBlackTree.Node)nodes.pop();
                    this.type.fromBigDecimalArray((BigDecimal[])n.value, 0);
                    list.set(n.key, this.type);
                    if (n.left != this.data.nil) {
                        nodes.push(n.left);
                    }
                    if (n.right == this.data.nil) continue;
                    nodes.push(n.right);
                }
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(long index, U value) {
        SparseStorageBigDecimal sparseStorageBigDecimal = this;
        synchronized (sparseStorageBigDecimal) {
            if (index < 0L || index >= this.numElements) {
                throw new IllegalArgumentException("index out of bounds");
            }
            value.toBigDecimalArray(this.tmp, 0);
            RedBlackTree.Node node = this.data.findElement(index);
            if (Arrays.equals(this.tmp, this.zero)) {
                if (node != this.data.nil) {
                    this.data.delete(node);
                }
            } else if (node == this.data.nil) {
                RedBlackTree.Node n = new RedBlackTree.Node(this.data);
                n.key = index;
                n.p = this.data.nil;
                n.left = this.data.nil;
                n.right = this.data.nil;
                n.value = new BigDecimal[this.tmp.length];
                for (int i = 0; i < this.tmp.length; ++i) {
                    ((BigDecimal[])n.value)[i] = this.tmp[i];
                }
                this.data.insert(n);
            } else {
                value.toBigDecimalArray((BigDecimal[])node.value, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void get(long index, U value) {
        SparseStorageBigDecimal sparseStorageBigDecimal = this;
        synchronized (sparseStorageBigDecimal) {
            if (index < 0L || index >= this.numElements) {
                throw new IllegalArgumentException("index out of bounds");
            }
            RedBlackTree.Node node = this.data.findElement(index);
            if (node == this.data.nil) {
                value.fromBigDecimalArray(this.zero, 0);
            } else {
                value.fromBigDecimalArray((BigDecimal[])node.value, 0);
            }
        }
    }

    @Override
    public long size() {
        return this.numElements;
    }

    @Override
    public SparseStorageBigDecimal<U> allocate() {
        return new SparseStorageBigDecimal<U>(this.size(), this.type);
    }

    @Override
    public StorageConstruction storageType() {
        return StorageConstruction.MEM_SPARSE;
    }
}

