/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.sparse;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Stack;
import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.storage.coder.BigIntegerCoder;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;
import nom.bdezonia.zorbage.type.storage.sparse.RedBlackTree;

public class SparseStorageBigInteger<U extends BigIntegerCoder & Allocatable<U>>
implements IndexedDataSource<U>,
Allocatable<SparseStorageBigInteger<U>> {
    private final RedBlackTree<BigInteger[]> data;
    private final long numElements;
    private final BigInteger[] zero;
    private final BigInteger[] tmp;
    private final U type;

    public SparseStorageBigInteger(long numElements, U type) {
        this.numElements = numElements;
        this.type = (BigIntegerCoder)((Allocatable)type).allocate();
        this.zero = new BigInteger[type.bigIntegerCount()];
        this.tmp = new BigInteger[type.bigIntegerCount()];
        this.data = new RedBlackTree();
        for (int i = 0; i < type.bigIntegerCount(); ++i) {
            this.zero[i] = BigInteger.ZERO;
            this.tmp[i] = BigInteger.ZERO;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SparseStorageBigInteger<U> duplicate() {
        SparseStorageBigInteger sparseStorageBigInteger = this;
        synchronized (sparseStorageBigInteger) {
            SparseStorageBigInteger<U> list = new SparseStorageBigInteger<U>(this.numElements, this.type);
            Stack<RedBlackTree.Node> nodes = new Stack<RedBlackTree.Node>();
            if (this.data.root != this.data.nil) {
                nodes.push(this.data.root);
                while (!nodes.isEmpty()) {
                    RedBlackTree.Node n = (RedBlackTree.Node)nodes.pop();
                    this.type.fromBigIntegerArray((BigInteger[])n.value, 0);
                    list.set(n.key, this.type);
                    if (n.left != this.data.nil) {
                        nodes.push(n.left);
                    }
                    if (n.right == this.data.nil) continue;
                    nodes.push(n.right);
                }
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(long index, U value) {
        SparseStorageBigInteger sparseStorageBigInteger = this;
        synchronized (sparseStorageBigInteger) {
            if (index < 0L || index >= this.numElements) {
                throw new IllegalArgumentException("index out of bounds");
            }
            value.toBigIntegerArray(this.tmp, 0);
            RedBlackTree.Node node = this.data.findElement(index);
            if (Arrays.equals(this.tmp, this.zero)) {
                if (node != this.data.nil) {
                    this.data.delete(node);
                }
            } else if (node == this.data.nil) {
                RedBlackTree.Node n = new RedBlackTree.Node(this.data);
                n.key = index;
                n.p = this.data.nil;
                n.left = this.data.nil;
                n.right = this.data.nil;
                n.value = new BigInteger[this.tmp.length];
                for (int i = 0; i < this.tmp.length; ++i) {
                    ((BigInteger[])n.value)[i] = this.tmp[i];
                }
                this.data.insert(n);
            } else {
                value.toBigIntegerArray((BigInteger[])node.value, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void get(long index, U value) {
        SparseStorageBigInteger sparseStorageBigInteger = this;
        synchronized (sparseStorageBigInteger) {
            if (index < 0L || index >= this.numElements) {
                throw new IllegalArgumentException("index out of bounds");
            }
            RedBlackTree.Node node = this.data.findElement(index);
            if (node == this.data.nil) {
                value.fromBigIntegerArray(this.zero, 0);
            } else {
                value.fromBigIntegerArray((BigInteger[])node.value, 0);
            }
        }
    }

    @Override
    public long size() {
        return this.numElements;
    }

    @Override
    public SparseStorageBigInteger<U> allocate() {
        return new SparseStorageBigInteger<U>(this.size(), this.type);
    }

    @Override
    public StorageConstruction storageType() {
        return StorageConstruction.MEM_SPARSE;
    }
}

