/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.sparse;

import java.util.Arrays;
import java.util.Stack;
import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.storage.coder.BooleanCoder;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;
import nom.bdezonia.zorbage.type.storage.sparse.RedBlackTree;

public class SparseStorageBoolean<U extends BooleanCoder & Allocatable<U>>
implements IndexedDataSource<U>,
Allocatable<SparseStorageBoolean<U>> {
    private final RedBlackTree<boolean[]> data;
    private final long numElements;
    private final boolean[] zero;
    private final boolean[] tmp;
    private final U type;

    public SparseStorageBoolean(long numElements, U type) {
        this.numElements = numElements;
        this.type = (BooleanCoder)((Allocatable)type).allocate();
        this.zero = new boolean[type.booleanCount()];
        this.tmp = new boolean[type.booleanCount()];
        this.data = new RedBlackTree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SparseStorageBoolean<U> duplicate() {
        SparseStorageBoolean sparseStorageBoolean = this;
        synchronized (sparseStorageBoolean) {
            SparseStorageBoolean<U> list = new SparseStorageBoolean<U>(this.numElements, this.type);
            Stack<RedBlackTree.Node> nodes = new Stack<RedBlackTree.Node>();
            if (this.data.root != this.data.nil) {
                nodes.push(this.data.root);
                while (!nodes.isEmpty()) {
                    RedBlackTree.Node n = (RedBlackTree.Node)nodes.pop();
                    this.type.fromBooleanArray((boolean[])n.value, 0);
                    list.set(n.key, this.type);
                    if (n.left != this.data.nil) {
                        nodes.push(n.left);
                    }
                    if (n.right == this.data.nil) continue;
                    nodes.push(n.right);
                }
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(long index, U value) {
        SparseStorageBoolean sparseStorageBoolean = this;
        synchronized (sparseStorageBoolean) {
            if (index < 0L || index >= this.numElements) {
                throw new IllegalArgumentException("index out of bounds");
            }
            value.toBooleanArray(this.tmp, 0);
            RedBlackTree.Node node = this.data.findElement(index);
            if (Arrays.equals(this.tmp, this.zero)) {
                if (node != this.data.nil) {
                    this.data.delete(node);
                }
            } else if (node == this.data.nil) {
                RedBlackTree.Node n = this.data.new RedBlackTree.Node();
                n.key = index;
                n.p = this.data.nil;
                n.left = this.data.nil;
                n.right = this.data.nil;
                n.value = new boolean[this.tmp.length];
                for (int i = 0; i < this.tmp.length; ++i) {
                    ((boolean[])n.value)[i] = this.tmp[i];
                }
                this.data.insert(n);
            } else {
                value.toBooleanArray((boolean[])node.value, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void get(long index, U value) {
        SparseStorageBoolean sparseStorageBoolean = this;
        synchronized (sparseStorageBoolean) {
            if (index < 0L || index >= this.numElements) {
                throw new IllegalArgumentException("index out of bounds");
            }
            RedBlackTree.Node node = this.data.findElement(index);
            if (node == this.data.nil) {
                value.fromBooleanArray(this.zero, 0);
            } else {
                value.fromBooleanArray((boolean[])node.value, 0);
            }
        }
    }

    @Override
    public long size() {
        return this.numElements;
    }

    @Override
    public SparseStorageBoolean<U> allocate() {
        return new SparseStorageBoolean<U>(this.size(), this.type);
    }

    @Override
    public StorageConstruction storageType() {
        return StorageConstruction.MEM_SPARSE;
    }
}

