/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.sparse;

import java.util.Arrays;
import java.util.Stack;
import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.ctor.StorageType;
import nom.bdezonia.zorbage.type.storage.coder.DoubleCoder;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;
import nom.bdezonia.zorbage.type.storage.sparse.RedBlackTree;

public class SparseStorageFloat64<U extends DoubleCoder & Allocatable<U>>
implements IndexedDataSource<U>,
Allocatable<SparseStorageFloat64<U>>,
StorageType {
    private final RedBlackTree<double[]> data;
    private final long numElements;
    private final double[] zero;
    private final double[] tmp;
    private final U type;

    public SparseStorageFloat64(long numElements, U type) {
        this.numElements = numElements;
        this.type = (DoubleCoder)((Allocatable)type).allocate();
        this.zero = new double[type.doubleCount()];
        this.tmp = new double[type.doubleCount()];
        this.data = new RedBlackTree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SparseStorageFloat64<U> duplicate() {
        SparseStorageFloat64 sparseStorageFloat64 = this;
        synchronized (sparseStorageFloat64) {
            SparseStorageFloat64<U> list = new SparseStorageFloat64<U>(this.numElements, this.type);
            Stack<RedBlackTree.Node> nodes = new Stack<RedBlackTree.Node>();
            if (this.data.root != this.data.nil) {
                nodes.push(this.data.root);
                while (!nodes.isEmpty()) {
                    RedBlackTree.Node n = (RedBlackTree.Node)nodes.pop();
                    this.type.fromDoubleArray((double[])n.value, 0);
                    list.set(n.key, this.type);
                    if (n.left != this.data.nil) {
                        nodes.push(n.left);
                    }
                    if (n.right == this.data.nil) continue;
                    nodes.push(n.right);
                }
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(long index, U value) {
        SparseStorageFloat64 sparseStorageFloat64 = this;
        synchronized (sparseStorageFloat64) {
            if (index < 0L || index >= this.numElements) {
                throw new IllegalArgumentException("index out of bounds");
            }
            value.toDoubleArray(this.tmp, 0);
            RedBlackTree.Node node = this.data.findElement(index);
            if (Arrays.equals(this.tmp, this.zero)) {
                if (node != this.data.nil) {
                    this.data.delete(node);
                }
            } else if (node == this.data.nil) {
                RedBlackTree.Node n = new RedBlackTree.Node(this.data);
                n.key = index;
                n.p = this.data.nil;
                n.left = this.data.nil;
                n.right = this.data.nil;
                n.value = new double[this.tmp.length];
                for (int i = 0; i < this.tmp.length; ++i) {
                    ((double[])n.value)[i] = this.tmp[i];
                }
                this.data.insert(n);
            } else {
                value.toDoubleArray((double[])node.value, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void get(long index, U value) {
        SparseStorageFloat64 sparseStorageFloat64 = this;
        synchronized (sparseStorageFloat64) {
            if (index < 0L || index >= this.numElements) {
                throw new IllegalArgumentException("index out of bounds");
            }
            RedBlackTree.Node node = this.data.findElement(index);
            if (node == this.data.nil) {
                value.fromDoubleArray(this.zero, 0);
            } else {
                value.fromDoubleArray((double[])node.value, 0);
            }
        }
    }

    @Override
    public long size() {
        return this.numElements;
    }

    @Override
    public SparseStorageFloat64<U> allocate() {
        return new SparseStorageFloat64<U>(this.size(), this.type);
    }

    @Override
    public StorageConstruction storageType() {
        return StorageConstruction.MEM_SPARSE;
    }
}

