/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.sparse;

import java.util.Arrays;
import java.util.Stack;
import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.storage.coder.ShortCoder;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;
import nom.bdezonia.zorbage.type.storage.sparse.RedBlackTree;

public class SparseStorageSignedInt16<U extends ShortCoder & Allocatable<U>>
implements IndexedDataSource<U>,
Allocatable<SparseStorageSignedInt16<U>> {
    private final RedBlackTree<short[]> data;
    private final long numElements;
    private final short[] zero;
    private final short[] tmp;
    private final U type;

    public SparseStorageSignedInt16(long numElements, U type) {
        this.numElements = numElements;
        this.type = (ShortCoder)((Allocatable)type).allocate();
        this.zero = new short[type.shortCount()];
        this.tmp = new short[type.shortCount()];
        this.data = new RedBlackTree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SparseStorageSignedInt16<U> duplicate() {
        SparseStorageSignedInt16 sparseStorageSignedInt16 = this;
        synchronized (sparseStorageSignedInt16) {
            SparseStorageSignedInt16<U> list = new SparseStorageSignedInt16<U>(this.numElements, this.type);
            Stack<RedBlackTree.Node> nodes = new Stack<RedBlackTree.Node>();
            if (this.data.root != this.data.nil) {
                nodes.push(this.data.root);
                while (!nodes.isEmpty()) {
                    RedBlackTree.Node n = (RedBlackTree.Node)nodes.pop();
                    this.type.fromShortArray((short[])n.value, 0);
                    list.set(n.key, this.type);
                    if (n.left != this.data.nil) {
                        nodes.push(n.left);
                    }
                    if (n.right == this.data.nil) continue;
                    nodes.push(n.right);
                }
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(long index, U value) {
        SparseStorageSignedInt16 sparseStorageSignedInt16 = this;
        synchronized (sparseStorageSignedInt16) {
            if (index < 0L || index >= this.numElements) {
                throw new IllegalArgumentException("index out of bounds");
            }
            value.toShortArray(this.tmp, 0);
            RedBlackTree.Node node = this.data.findElement(index);
            if (Arrays.equals(this.tmp, this.zero)) {
                if (node != this.data.nil) {
                    this.data.delete(node);
                }
            } else if (node == this.data.nil) {
                RedBlackTree.Node n = new RedBlackTree.Node(this.data);
                n.key = index;
                n.p = this.data.nil;
                n.left = this.data.nil;
                n.right = this.data.nil;
                n.value = new short[this.tmp.length];
                for (int i = 0; i < this.tmp.length; ++i) {
                    ((short[])n.value)[i] = this.tmp[i];
                }
                this.data.insert(n);
            } else {
                value.toShortArray((short[])node.value, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void get(long index, U value) {
        SparseStorageSignedInt16 sparseStorageSignedInt16 = this;
        synchronized (sparseStorageSignedInt16) {
            if (index < 0L || index >= this.numElements) {
                throw new IllegalArgumentException("index out of bounds");
            }
            RedBlackTree.Node node = this.data.findElement(index);
            if (node == this.data.nil) {
                value.fromShortArray(this.zero, 0);
            } else {
                value.fromShortArray((short[])node.value, 0);
            }
        }
    }

    @Override
    public long size() {
        return this.numElements;
    }

    @Override
    public SparseStorageSignedInt16<U> allocate() {
        return new SparseStorageSignedInt16<U>(this.size(), this.type);
    }

    @Override
    public StorageConstruction storageType() {
        return StorageConstruction.MEM_SPARSE;
    }
}

