/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.sparse;

import java.util.Arrays;
import java.util.Stack;
import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.storage.coder.IntCoder;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;
import nom.bdezonia.zorbage.type.storage.sparse.RedBlackTree;

public class SparseStorageSignedInt32<U extends IntCoder & Allocatable<U>>
implements IndexedDataSource<U>,
Allocatable<SparseStorageSignedInt32<U>> {
    private final RedBlackTree<int[]> data;
    private final long numElements;
    private final int[] zero;
    private final int[] tmp;
    private final U type;

    public SparseStorageSignedInt32(long numElements, U type) {
        this.numElements = numElements;
        this.type = (IntCoder)((Allocatable)type).allocate();
        this.zero = new int[type.intCount()];
        this.tmp = new int[type.intCount()];
        this.data = new RedBlackTree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SparseStorageSignedInt32<U> duplicate() {
        SparseStorageSignedInt32 sparseStorageSignedInt32 = this;
        synchronized (sparseStorageSignedInt32) {
            SparseStorageSignedInt32<U> list = new SparseStorageSignedInt32<U>(this.numElements, this.type);
            Stack<RedBlackTree.Node> nodes = new Stack<RedBlackTree.Node>();
            if (this.data.root != this.data.nil) {
                nodes.push(this.data.root);
                while (!nodes.isEmpty()) {
                    RedBlackTree.Node n = (RedBlackTree.Node)nodes.pop();
                    this.type.fromIntArray((int[])n.value, 0);
                    list.set(n.key, this.type);
                    if (n.left != this.data.nil) {
                        nodes.push(n.left);
                    }
                    if (n.right == this.data.nil) continue;
                    nodes.push(n.right);
                }
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(long index, U value) {
        SparseStorageSignedInt32 sparseStorageSignedInt32 = this;
        synchronized (sparseStorageSignedInt32) {
            if (index < 0L || index >= this.numElements) {
                throw new IllegalArgumentException("index out of bounds");
            }
            value.toIntArray(this.tmp, 0);
            RedBlackTree.Node node = this.data.findElement(index);
            if (Arrays.equals(this.tmp, this.zero)) {
                if (node != this.data.nil) {
                    this.data.delete(node);
                }
            } else if (node == this.data.nil) {
                RedBlackTree.Node n = this.data.new RedBlackTree.Node();
                n.key = index;
                n.p = this.data.nil;
                n.left = this.data.nil;
                n.right = this.data.nil;
                n.value = new int[this.tmp.length];
                for (int i = 0; i < this.tmp.length; ++i) {
                    ((int[])n.value)[i] = this.tmp[i];
                }
                this.data.insert(n);
            } else {
                value.toIntArray((int[])node.value, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void get(long index, U value) {
        SparseStorageSignedInt32 sparseStorageSignedInt32 = this;
        synchronized (sparseStorageSignedInt32) {
            if (index < 0L || index >= this.numElements) {
                throw new IllegalArgumentException("index out of bounds");
            }
            RedBlackTree.Node node = this.data.findElement(index);
            if (node == this.data.nil) {
                value.fromIntArray(this.zero, 0);
            } else {
                value.fromIntArray((int[])node.value, 0);
            }
        }
    }

    @Override
    public long size() {
        return this.numElements;
    }

    @Override
    public SparseStorageSignedInt32<U> allocate() {
        return new SparseStorageSignedInt32<U>(this.size(), this.type);
    }

    @Override
    public StorageConstruction storageType() {
        return StorageConstruction.MEM_SPARSE;
    }
}

