/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.sparse;

import java.util.Arrays;
import java.util.Stack;
import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.storage.coder.LongCoder;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;
import nom.bdezonia.zorbage.type.storage.sparse.RedBlackTree;

public class SparseStorageSignedInt64<U extends LongCoder & Allocatable<U>>
implements IndexedDataSource<U>,
Allocatable<SparseStorageSignedInt64<U>> {
    private final RedBlackTree<long[]> data;
    private final long numElements;
    private final long[] zero;
    private final long[] tmp;
    private final U type;

    public SparseStorageSignedInt64(long numElements, U type) {
        this.numElements = numElements;
        this.type = (LongCoder)((Allocatable)type).allocate();
        this.zero = new long[type.longCount()];
        this.tmp = new long[type.longCount()];
        this.data = new RedBlackTree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SparseStorageSignedInt64<U> duplicate() {
        SparseStorageSignedInt64 sparseStorageSignedInt64 = this;
        synchronized (sparseStorageSignedInt64) {
            SparseStorageSignedInt64<U> list = new SparseStorageSignedInt64<U>(this.numElements, this.type);
            Stack<RedBlackTree.Node> nodes = new Stack<RedBlackTree.Node>();
            if (this.data.root != this.data.nil) {
                nodes.push(this.data.root);
                while (!nodes.isEmpty()) {
                    RedBlackTree.Node n = (RedBlackTree.Node)nodes.pop();
                    this.type.fromLongArray((long[])n.value, 0);
                    list.set(n.key, this.type);
                    if (n.left != this.data.nil) {
                        nodes.push(n.left);
                    }
                    if (n.right == this.data.nil) continue;
                    nodes.push(n.right);
                }
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(long index, U value) {
        SparseStorageSignedInt64 sparseStorageSignedInt64 = this;
        synchronized (sparseStorageSignedInt64) {
            if (index < 0L || index >= this.numElements) {
                throw new IllegalArgumentException("index out of bounds");
            }
            value.toLongArray(this.tmp, 0);
            RedBlackTree.Node node = this.data.findElement(index);
            if (Arrays.equals(this.tmp, this.zero)) {
                if (node != this.data.nil) {
                    this.data.delete(node);
                }
            } else if (node == this.data.nil) {
                RedBlackTree.Node n = new RedBlackTree.Node(this.data);
                n.key = index;
                n.p = this.data.nil;
                n.left = this.data.nil;
                n.right = this.data.nil;
                n.value = new long[this.tmp.length];
                for (int i = 0; i < this.tmp.length; ++i) {
                    ((long[])n.value)[i] = this.tmp[i];
                }
                this.data.insert(n);
            } else {
                value.toLongArray((long[])node.value, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void get(long index, U value) {
        SparseStorageSignedInt64 sparseStorageSignedInt64 = this;
        synchronized (sparseStorageSignedInt64) {
            if (index < 0L || index >= this.numElements) {
                throw new IllegalArgumentException("index out of bounds");
            }
            RedBlackTree.Node node = this.data.findElement(index);
            if (node == this.data.nil) {
                value.fromLongArray(this.zero, 0);
            } else {
                value.fromLongArray((long[])node.value, 0);
            }
        }
    }

    @Override
    public long size() {
        return this.numElements;
    }

    @Override
    public SparseStorageSignedInt64<U> allocate() {
        return new SparseStorageSignedInt64<U>(this.size(), this.type);
    }

    @Override
    public StorageConstruction storageType() {
        return StorageConstruction.MEM_SPARSE;
    }
}

