/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.storage.sparse;

import java.util.Arrays;
import java.util.Stack;
import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.storage.coder.ByteCoder;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;
import nom.bdezonia.zorbage.type.storage.sparse.RedBlackTree;

public class SparseStorageSignedInt8<U extends ByteCoder & Allocatable<U>>
implements IndexedDataSource<U>,
Allocatable<SparseStorageSignedInt8<U>> {
    private final RedBlackTree<byte[]> data;
    private final long numElements;
    private final byte[] zero;
    private final byte[] tmp;
    private final U type;

    public SparseStorageSignedInt8(long numElements, U type) {
        this.numElements = numElements;
        this.type = (ByteCoder)((Allocatable)type).allocate();
        this.zero = new byte[type.byteCount()];
        this.tmp = new byte[type.byteCount()];
        this.data = new RedBlackTree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SparseStorageSignedInt8<U> duplicate() {
        SparseStorageSignedInt8 sparseStorageSignedInt8 = this;
        synchronized (sparseStorageSignedInt8) {
            SparseStorageSignedInt8<U> list = new SparseStorageSignedInt8<U>(this.numElements, this.type);
            Stack<RedBlackTree.Node> nodes = new Stack<RedBlackTree.Node>();
            if (this.data.root != this.data.nil) {
                nodes.push(this.data.root);
                while (!nodes.isEmpty()) {
                    RedBlackTree.Node n = (RedBlackTree.Node)nodes.pop();
                    this.type.fromByteArray((byte[])n.value, 0);
                    list.set(n.key, this.type);
                    if (n.left != this.data.nil) {
                        nodes.push(n.left);
                    }
                    if (n.right == this.data.nil) continue;
                    nodes.push(n.right);
                }
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(long index, U value) {
        SparseStorageSignedInt8 sparseStorageSignedInt8 = this;
        synchronized (sparseStorageSignedInt8) {
            if (index < 0L || index >= this.numElements) {
                throw new IllegalArgumentException("index out of bounds");
            }
            value.toByteArray(this.tmp, 0);
            RedBlackTree.Node node = this.data.findElement(index);
            if (Arrays.equals(this.tmp, this.zero)) {
                if (node != this.data.nil) {
                    this.data.delete(node);
                }
            } else if (node == this.data.nil) {
                RedBlackTree.Node n = this.data.new RedBlackTree.Node();
                n.key = index;
                n.p = this.data.nil;
                n.left = this.data.nil;
                n.right = this.data.nil;
                n.value = new byte[this.tmp.length];
                for (int i = 0; i < this.tmp.length; ++i) {
                    ((byte[])n.value)[i] = this.tmp[i];
                }
                this.data.insert(n);
            } else {
                value.toByteArray((byte[])node.value, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void get(long index, U value) {
        SparseStorageSignedInt8 sparseStorageSignedInt8 = this;
        synchronized (sparseStorageSignedInt8) {
            if (index < 0L || index >= this.numElements) {
                throw new IllegalArgumentException("index out of bounds");
            }
            RedBlackTree.Node node = this.data.findElement(index);
            if (node == this.data.nil) {
                value.fromByteArray(this.zero, 0);
            } else {
                value.fromByteArray((byte[])node.value, 0);
            }
        }
    }

    @Override
    public long size() {
        return this.numElements;
    }

    @Override
    public SparseStorageSignedInt8<U> allocate() {
        return new SparseStorageSignedInt8<U>(this.size(), this.type);
    }

    @Override
    public StorageConstruction storageType() {
        return StorageConstruction.MEM_SPARSE;
    }
}

