/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans.randomizers.jodatime.registry;

import io.github.benas.randombeans.annotation.Priority;
import io.github.benas.randombeans.api.Randomizer;
import io.github.benas.randombeans.api.RandomizerRegistry;
import io.github.benas.randombeans.randomizers.jodatime.JodaTimeDateTimeRandomizer;
import io.github.benas.randombeans.randomizers.jodatime.JodaTimeDurationRandomizer;
import io.github.benas.randombeans.randomizers.jodatime.JodaTimeIntervalRandomizer;
import io.github.benas.randombeans.randomizers.jodatime.JodaTimeLocalDateRandomizer;
import io.github.benas.randombeans.randomizers.jodatime.JodaTimeLocalDateTimeRandomizer;
import io.github.benas.randombeans.randomizers.jodatime.JodaTimeLocalTimeRandomizer;
import io.github.benas.randombeans.randomizers.jodatime.JodaTimePeriodRandomizer;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.Period;

@Priority(value=-255)
public class JodaTimeRandomizerRegistry
implements RandomizerRegistry {
    private Map<Class<?>, Randomizer<?>> randomizers = new HashMap();

    public void setSeed(long seed) {
        this.randomizers.put(DateTime.class, new JodaTimeDateTimeRandomizer(seed));
        this.randomizers.put(LocalDate.class, new JodaTimeLocalDateRandomizer(seed));
        this.randomizers.put(LocalTime.class, new JodaTimeLocalTimeRandomizer(seed));
        this.randomizers.put(LocalDateTime.class, new JodaTimeLocalDateTimeRandomizer(seed));
        this.randomizers.put(Duration.class, new JodaTimeDurationRandomizer(seed));
        this.randomizers.put(Period.class, new JodaTimePeriodRandomizer(seed));
        this.randomizers.put(Interval.class, new JodaTimeIntervalRandomizer(seed));
    }

    public Randomizer<?> getRandomizer(Field field) {
        return this.getRandomizer(field.getType());
    }

    public Randomizer<?> getRandomizer(Class<?> type) {
        return this.randomizers.get(type);
    }
}

