/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans.randomizers;

import io.github.benas.randombeans.randomizers.AbstractRandomizer;

public class EnumRandomizer<T extends Enum<T>>
extends AbstractRandomizer<Enum<T>> {
    private Class<T> enumeration;

    public EnumRandomizer(Class<T> enumeration) {
        this.enumeration = enumeration;
    }

    public EnumRandomizer(Class<T> enumeration, long seed) {
        super(seed);
        this.enumeration = enumeration;
    }

    public static <R extends Enum<R>> EnumRandomizer<R> aNewEnumRandomizer(Class<R> enumeration) {
        return new EnumRandomizer<R>(enumeration);
    }

    public static <R extends Enum<R>> EnumRandomizer<R> aNewEnumRandomizer(Class<R> enumeration, long seed) {
        return new EnumRandomizer<R>(enumeration);
    }

    @Override
    public Enum<T> getRandomValue() {
        Enum[] enumConstants = (Enum[])this.enumeration.getEnumConstants();
        int randomIndex = this.random.nextInt(enumConstants.length);
        return enumConstants[randomIndex];
    }
}

