/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans.randomizers.number;

import io.github.benas.randombeans.api.Randomizer;
import io.github.benas.randombeans.randomizers.number.DoubleRandomizer;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class BigDecimalRandomizer
implements Randomizer<BigDecimal> {
    private final DoubleRandomizer delegate;
    private Integer scale;

    public BigDecimalRandomizer() {
        this.delegate = new DoubleRandomizer();
    }

    public BigDecimalRandomizer(long seed) {
        this.delegate = new DoubleRandomizer(seed);
    }

    public BigDecimalRandomizer(Integer scale) {
        this.delegate = new DoubleRandomizer();
        this.scale = scale;
    }

    public static BigDecimalRandomizer aNewBigDecimalRandomizer() {
        return new BigDecimalRandomizer();
    }

    public static BigDecimalRandomizer aNewBigDecimalRandomizer(long seed) {
        return new BigDecimalRandomizer(seed);
    }

    public static BigDecimalRandomizer aNewBigDecimalRandomizer(Integer scale) {
        return new BigDecimalRandomizer(scale);
    }

    @Override
    public BigDecimal getRandomValue() {
        BigDecimal randomValue = new BigDecimal(this.delegate.getRandomValue());
        if (this.scale != null) {
            randomValue = randomValue.setScale((int)this.scale, RoundingMode.HALF_UP);
        }
        return randomValue;
    }
}

