/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans.randomizers.range;

import io.github.benas.randombeans.randomizers.range.AbstractRangeRandomizer;
import java.time.LocalTime;
import java.time.temporal.ChronoField;

public class LocalTimeRangeRandomizer
extends AbstractRangeRandomizer<LocalTime> {
    public LocalTimeRangeRandomizer(LocalTime min, LocalTime max) {
        super(min, max);
    }

    public LocalTimeRangeRandomizer(LocalTime min, LocalTime max, long seed) {
        super(min, max, seed);
    }

    public static LocalTimeRangeRandomizer aNewLocalTimeRangeRandomizer(LocalTime min, LocalTime max) {
        return new LocalTimeRangeRandomizer(min, max);
    }

    public static LocalTimeRangeRandomizer aNewLocalTimeRangeRandomizer(LocalTime min, LocalTime max, long seed) {
        return new LocalTimeRangeRandomizer(min, max, seed);
    }

    @Override
    protected void checkValues() {
        if (((LocalTime)this.min).isAfter((LocalTime)this.max)) {
            throw new IllegalArgumentException("max must be after min");
        }
    }

    @Override
    protected LocalTime getDefaultMinValue() {
        return LocalTime.MIN;
    }

    @Override
    protected LocalTime getDefaultMaxValue() {
        return LocalTime.MAX;
    }

    @Override
    public LocalTime getRandomValue() {
        long minSecondOfDay = ((LocalTime)this.min).getLong(ChronoField.SECOND_OF_DAY);
        long maxSecondOfDay = ((LocalTime)this.max).getLong(ChronoField.SECOND_OF_DAY);
        long randomSecondOfDay = this.nextLong(minSecondOfDay, maxSecondOfDay);
        return LocalTime.ofSecondOfDay(randomSecondOfDay);
    }
}

