/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans.randomizers.time;

import io.github.benas.randombeans.api.Randomizer;
import io.github.benas.randombeans.randomizers.misc.EnumRandomizer;
import io.github.benas.randombeans.randomizers.time.YearRandomizer;
import java.time.Month;
import java.time.Year;
import java.time.YearMonth;

public class YearMonthRandomizer
implements Randomizer<YearMonth> {
    private final YearRandomizer yearRandomizer;
    private final EnumRandomizer<Month> monthRandomizer;

    public YearMonthRandomizer() {
        this.yearRandomizer = new YearRandomizer();
        this.monthRandomizer = new EnumRandomizer<Month>(Month.class);
    }

    public YearMonthRandomizer(long seed) {
        this.yearRandomizer = new YearRandomizer(seed);
        this.monthRandomizer = new EnumRandomizer<Month>(Month.class, seed);
    }

    public static YearMonthRandomizer aNewYearMonthRandomizer() {
        return new YearMonthRandomizer();
    }

    public static YearMonthRandomizer aNewYearMonthRandomizer(long seed) {
        return new YearMonthRandomizer(seed);
    }

    @Override
    public YearMonth getRandomValue() {
        Year randomYear = this.yearRandomizer.getRandomValue();
        Month randomMonth = (Month)this.monthRandomizer.getRandomValue();
        return YearMonth.of(randomYear.getValue(), randomMonth.getValue());
    }
}

