/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans.randomizers.registry;

import io.github.benas.randombeans.FieldDefinition;
import io.github.benas.randombeans.FieldPredicates;
import io.github.benas.randombeans.annotation.Priority;
import io.github.benas.randombeans.api.EnhancedRandomParameters;
import io.github.benas.randombeans.api.Randomizer;
import io.github.benas.randombeans.api.RandomizerRegistry;
import io.github.benas.randombeans.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;

@Priority(value=-1)
public class CustomRandomizerRegistry
implements RandomizerRegistry {
    private final Map<Predicate<Field>, Randomizer<?>> customFieldRandomizersRegistry = new HashMap();
    private final Map<Class<?>, Randomizer<?>> customTypeRandomizersRegistry = new HashMap();

    @Override
    public void init(EnhancedRandomParameters parameters) {
    }

    @Override
    public Randomizer<?> getRandomizer(Field field) {
        for (Predicate<Field> fieldPredicate : this.customFieldRandomizersRegistry.keySet()) {
            if (!fieldPredicate.test(field)) continue;
            return this.customFieldRandomizersRegistry.get(fieldPredicate);
        }
        return this.getRandomizer(field.getType());
    }

    @Override
    public Randomizer<?> getRandomizer(Class<?> type) {
        Randomizer<?> randomizer = this.customTypeRandomizersRegistry.get(type);
        if (randomizer == null) {
            Class<?> wrapperType = type.isPrimitive() ? ReflectionUtils.getWrapperType(type) : type;
            randomizer = this.customTypeRandomizersRegistry.get(wrapperType);
        }
        return randomizer;
    }

    public <T, F, R> void registerRandomizer(FieldDefinition<T, F> fieldDefinition, Randomizer<R> randomizer) {
        this.customFieldRandomizersRegistry.put(this.toPredicate(fieldDefinition), randomizer);
    }

    public <T, R> void registerRandomizer(Class<T> type, Randomizer<R> randomizer) {
        this.customTypeRandomizersRegistry.put(type, randomizer);
    }

    public void registerRandomizer(Predicate<Field> predicate, Randomizer<?> randomizer) {
        this.customFieldRandomizersRegistry.put(predicate, randomizer);
    }

    private Predicate<Field> toPredicate(FieldDefinition<?, ?> fieldDefinition) {
        Class[] annotations = new Class[fieldDefinition.getAnnotations().size()];
        return field -> FieldPredicates.named(fieldDefinition.getName()).and(FieldPredicates.ofType(fieldDefinition.getType())).and(FieldPredicates.inClass(fieldDefinition.getClazz())).and(FieldPredicates.hasModifiers(fieldDefinition.getModifiers())).and(FieldPredicates.isAnnotatedWith(fieldDefinition.getAnnotations().toArray(annotations))).test((Field)field);
    }
}

