/*
 * Decompiled with CFR 0.152.
 */
package com.berkleytechnologyservices.restdocs.spec;

import com.berkleytechnologyservices.restdocs.spec.AuthConfig;
import com.berkleytechnologyservices.restdocs.spec.SpecificationFormat;
import com.berkleytechnologyservices.restdocs.spec.Tag;
import java.util.Collections;
import java.util.List;

public class ApiDetails {
    private static final String DEFAULT_NAME = "API Documentation";
    private static final String DEFAULT_VERSION = "1.0.0";
    private static final String DEFAULT_HOST = "localhost";
    private static final List<String> DEFAULT_SCHEMES = Collections.singletonList("http");
    private static final SpecificationFormat DEFAULT_FORMAT = SpecificationFormat.YAML;
    private String name = "API Documentation";
    private String version = "1.0.0";
    private String description;
    private String host = "localhost";
    private String basePath = null;
    private List<String> schemes = DEFAULT_SCHEMES;
    private SpecificationFormat format = DEFAULT_FORMAT;
    private AuthConfig authConfig = new AuthConfig();
    private List<Tag> tags = Collections.emptyList();

    public String getName() {
        return this.name;
    }

    public ApiDetails name(String name) {
        this.name = name != null ? name : DEFAULT_NAME;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public ApiDetails version(String version) {
        this.version = version != null ? version : DEFAULT_VERSION;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public ApiDetails description(String description) {
        this.description = description;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public ApiDetails host(String host) {
        this.host = host != null ? host : DEFAULT_HOST;
        return this;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public ApiDetails basePath(String basePath) {
        this.basePath = basePath;
        return this;
    }

    public List<String> getSchemes() {
        return this.schemes;
    }

    public ApiDetails schemes(List<String> schemes) {
        this.schemes = schemes != null && !schemes.isEmpty() ? Collections.unmodifiableList(schemes) : DEFAULT_SCHEMES;
        return this;
    }

    public SpecificationFormat getFormat() {
        return this.format;
    }

    public ApiDetails format(SpecificationFormat format) {
        this.format = format != null ? format : DEFAULT_FORMAT;
        return this;
    }

    public AuthConfig getAuthConfig() {
        return this.authConfig;
    }

    public ApiDetails authConfig(AuthConfig authConfig) {
        this.authConfig = authConfig != null ? authConfig : new AuthConfig();
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public ApiDetails tags(List<Tag> tags) {
        this.tags = tags != null ? tags : this.tags;
        return this;
    }
}

