/*
 * Decompiled with CFR 0.152.
 */
package com.anyicomplex.gdx.lwjgl3.svm;

import com.badlogic.gdx.backends.lwjgl3.audio.OpenALMusic;
import com.badlogic.gdx.backends.lwjgl3.audio.OpenALSound;
import java.lang.reflect.Executable;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.RuntimeResourceSupport;

public class ReflectionRegistrationFeature
implements Feature {
    public void duringSetup(Feature.DuringSetupAccess access) {
        boolean isWindows = System.getProperty("os.name").contains("Windows");
        boolean isLinux = System.getProperty("os.name").contains("Linux");
        boolean isMac = System.getProperty("os.name").contains("Mac");
        if (isWindows) {
            ((RuntimeResourceSupport)ImageSingletons.lookup(RuntimeResourceSupport.class)).addResources(ConfigurationCondition.alwaysTrue(), ".+\\.dll");
        } else if (isLinux) {
            ((RuntimeResourceSupport)ImageSingletons.lookup(RuntimeResourceSupport.class)).addResources(ConfigurationCondition.alwaysTrue(), ".+\\.so");
        } else if (isMac) {
            ((RuntimeResourceSupport)ImageSingletons.lookup(RuntimeResourceSupport.class)).addResources(ConfigurationCondition.alwaysTrue(), ".+\\.dylib");
        } else {
            throw new IllegalStateException("Unable to detect OS. Please report this.");
        }
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        try {
            access.registerSubtypeReachabilityHandler((duringAnalysisAccess, aClass) -> RuntimeReflection.register((Executable[])aClass.getDeclaredConstructors()), OpenALSound.class);
            access.registerSubtypeReachabilityHandler((duringAnalysisAccess, aClass) -> RuntimeReflection.register((Executable[])aClass.getDeclaredConstructors()), OpenALMusic.class);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

