/*
 * Decompiled with CFR 0.152.
 */
package org.beyka.tiffbitmapfactory;

import android.graphics.Bitmap;
import android.util.Log;
import java.io.File;
import org.beyka.tiffbitmapfactory.CompressionScheme;
import org.beyka.tiffbitmapfactory.DecodeArea;
import org.beyka.tiffbitmapfactory.FillOrder;
import org.beyka.tiffbitmapfactory.IProgressListener;
import org.beyka.tiffbitmapfactory.Orientation;
import org.beyka.tiffbitmapfactory.Photometric;
import org.beyka.tiffbitmapfactory.PlanarConfig;
import org.beyka.tiffbitmapfactory.ResolutionUnit;
import org.beyka.tiffbitmapfactory.exceptions.CantOpenFileException;
import org.beyka.tiffbitmapfactory.exceptions.DecodeTiffException;
import org.beyka.tiffbitmapfactory.exceptions.NotEnoughtMemoryException;

public class TiffBitmapFactory {
    public static Bitmap decodeFile(File file) throws CantOpenFileException, DecodeTiffException, NotEnoughtMemoryException {
        return TiffBitmapFactory.decodeFile(file, new Options(), null);
    }

    public static Bitmap decodeFile(File file, Options options) throws CantOpenFileException, DecodeTiffException, NotEnoughtMemoryException {
        return TiffBitmapFactory.decodeFile(file, options, null);
    }

    public static Bitmap decodeFile(File file, Options options, IProgressListener listener) throws CantOpenFileException, DecodeTiffException, NotEnoughtMemoryException {
        long time = System.currentTimeMillis();
        Log.i((String)"THREAD", (String)("Starting decode " + file.getAbsolutePath()));
        Bitmap mbp = TiffBitmapFactory.nativeDecodePath(file.getAbsolutePath(), options, listener);
        Log.w((String)"THREAD", (String)("elapsed ms: " + (System.currentTimeMillis() - time) + " for " + file.getAbsolutePath()));
        return mbp;
    }

    public static Bitmap decodePath(String path) throws CantOpenFileException, DecodeTiffException, NotEnoughtMemoryException {
        return TiffBitmapFactory.decodePath(path, new Options(), null);
    }

    public static Bitmap decodePath(String path, Options options) throws CantOpenFileException, DecodeTiffException, NotEnoughtMemoryException {
        return TiffBitmapFactory.decodePath(path, options);
    }

    public static Bitmap decodePath(String path, Options options, IProgressListener listener) throws CantOpenFileException, DecodeTiffException, NotEnoughtMemoryException {
        long time = System.currentTimeMillis();
        Log.i((String)"THREAD", (String)("Starting decode " + path));
        Bitmap mbp = TiffBitmapFactory.nativeDecodePath(path, options, listener);
        Log.w((String)"THREAD", (String)("elapsed ms: " + (System.currentTimeMillis() - time) + " for " + path));
        return mbp;
    }

    public static Bitmap decodeFileDescriptor(int fileDescriptor) throws CantOpenFileException, DecodeTiffException, NotEnoughtMemoryException {
        return TiffBitmapFactory.decodeFileDescriptor(fileDescriptor, new Options(), null);
    }

    public static Bitmap decodeFileDescriptor(int fileDescriptor, Options options) throws CantOpenFileException, DecodeTiffException, NotEnoughtMemoryException {
        return TiffBitmapFactory.decodeFileDescriptor(fileDescriptor, options, null);
    }

    public static Bitmap decodeFileDescriptor(int fileDescriptor, Options options, IProgressListener listener) throws CantOpenFileException, DecodeTiffException, NotEnoughtMemoryException {
        long time = System.currentTimeMillis();
        Log.i((String)"THREAD", (String)("Starting decode descriptor " + fileDescriptor));
        Bitmap mbp = TiffBitmapFactory.nativeDecodeFD(fileDescriptor, options, listener);
        Log.w((String)"THREAD", (String)("elapsed ms: " + (System.currentTimeMillis() - time) + " for descriptor " + fileDescriptor));
        return mbp;
    }

    private static native Bitmap nativeDecodePath(String var0, Options var1, IProgressListener var2);

    private static native Bitmap nativeDecodeFD(int var0, Options var1, IProgressListener var2);

    static {
        System.loadLibrary("tiff");
        System.loadLibrary("tifffactory");
    }

    public static final class Options {
        private volatile boolean isStoped = false;
        public boolean inUseOrientationTag = false;
        public boolean inThrowException = false;
        public boolean inSwapRedBlueColors = false;
        public boolean inJustDecodeBounds = false;
        public int inSampleSize = 1;
        public int inDirectoryNumber = 0;
        public long inAvailableMemory = 256000000L;
        public ImageConfig inPreferredConfig = ImageConfig.ARGB_8888;
        public DecodeArea inDecodeArea;
        public int outWidth = -1;
        public int outHeight = -1;
        public int outCurDirectoryNumber;
        public int outDirectoryCount = -1;
        public Orientation outImageOrientation = Orientation.UNAVAILABLE;
        public CompressionScheme outCompressionScheme;
        public PlanarConfig outPlanarConfig;
        public int outSamplePerPixel;
        public int outBitsPerSample;
        public float outXResolution;
        public float outYResolution;
        public ResolutionUnit outResolutionUnit;
        public int outTileWidth;
        public int outTileHeight;
        public int outRowPerStrip;
        public int outStripSize;
        public int outNumberOfStrips;
        public Photometric outPhotometric;
        public FillOrder outFillOrder;
        public String outAuthor = "";
        public String outCopyright = "";
        public String outImageDescription = "";
        public String outSoftware = "";
        public String outDatetime = "";
        public String outHostComputer = "";

        public void stop() {
            this.isStoped = true;
        }
    }

    public static enum ImageConfig {
        ARGB_8888(2),
        RGB_565(4),
        ALPHA_8(8);

        final int ordinal;

        private ImageConfig(int ordinal) {
            this.ordinal = ordinal;
        }
    }
}

