/*
 * Decompiled with CFR 0.152.
 */
package org.beyka.tiffbitmapfactory;

import java.io.File;
import org.beyka.tiffbitmapfactory.CompressionScheme;
import org.beyka.tiffbitmapfactory.DecodeArea;
import org.beyka.tiffbitmapfactory.IProgressListener;
import org.beyka.tiffbitmapfactory.ImageFormat;
import org.beyka.tiffbitmapfactory.ResolutionUnit;
import org.beyka.tiffbitmapfactory.exceptions.CantOpenFileException;
import org.beyka.tiffbitmapfactory.exceptions.DecodeTiffException;
import org.beyka.tiffbitmapfactory.exceptions.NotEnoughtMemoryException;

public class TiffConverter {
    public static boolean convertToTiff(File inFile, File outFile, ConverterOptions options, IProgressListener listener) throws CantOpenFileException, DecodeTiffException, NotEnoughtMemoryException {
        return TiffConverter.convertToTiff(inFile.getAbsolutePath(), outFile.getAbsolutePath(), options, listener);
    }

    public static boolean convertToTiff(String inPath, String outPath, ConverterOptions options, IProgressListener listener) throws CantOpenFileException, DecodeTiffException, NotEnoughtMemoryException {
        switch (TiffConverter.getImageType(inPath)) {
            case JPEG: {
                return TiffConverter.convertJpgTiff(inPath, outPath, options, listener);
            }
            case PNG: {
                return TiffConverter.convertPngTiff(inPath, outPath, options, listener);
            }
            case BMP: {
                return TiffConverter.convertBmpTiff(inPath, outPath, options, listener);
            }
        }
        return false;
    }

    public static boolean convertToTiff(int inFd, int outFd, ConverterOptions options, IProgressListener listener) throws CantOpenFileException, DecodeTiffException, NotEnoughtMemoryException {
        switch (TiffConverter.getImageTypeFd(inFd)) {
            case JPEG: {
                return TiffConverter.convertJpgTiffFd(inFd, outFd, options, listener);
            }
            case PNG: {
                return TiffConverter.convertPngTiffFd(inFd, outFd, options, listener);
            }
            case BMP: {
                return TiffConverter.convertBmpTiffFd(inFd, outFd, options, listener);
            }
        }
        return false;
    }

    public static native boolean convertTiffPng(String var0, String var1, ConverterOptions var2, IProgressListener var3) throws CantOpenFileException, DecodeTiffException, NotEnoughtMemoryException;

    public static native boolean convertTiffPngFd(int var0, int var1, ConverterOptions var2, IProgressListener var3) throws CantOpenFileException, DecodeTiffException, NotEnoughtMemoryException;

    public static native boolean convertPngTiff(String var0, String var1, ConverterOptions var2, IProgressListener var3) throws CantOpenFileException, DecodeTiffException, NotEnoughtMemoryException;

    public static native boolean convertPngTiffFd(int var0, int var1, ConverterOptions var2, IProgressListener var3) throws CantOpenFileException, DecodeTiffException, NotEnoughtMemoryException;

    public static native boolean convertTiffJpg(String var0, String var1, ConverterOptions var2, IProgressListener var3) throws CantOpenFileException, DecodeTiffException, NotEnoughtMemoryException;

    public static native boolean convertTiffJpgFd(int var0, int var1, ConverterOptions var2, IProgressListener var3) throws CantOpenFileException, DecodeTiffException, NotEnoughtMemoryException;

    public static native boolean convertJpgTiff(String var0, String var1, ConverterOptions var2, IProgressListener var3) throws CantOpenFileException, DecodeTiffException, NotEnoughtMemoryException;

    public static native boolean convertJpgTiffFd(int var0, int var1, ConverterOptions var2, IProgressListener var3) throws CantOpenFileException, DecodeTiffException, NotEnoughtMemoryException;

    public static native boolean convertTiffBmp(String var0, String var1, ConverterOptions var2, IProgressListener var3) throws CantOpenFileException, DecodeTiffException, NotEnoughtMemoryException;

    public static native boolean convertTiffBmpFd(int var0, int var1, ConverterOptions var2, IProgressListener var3) throws CantOpenFileException, DecodeTiffException, NotEnoughtMemoryException;

    public static native boolean convertBmpTiff(String var0, String var1, ConverterOptions var2, IProgressListener var3) throws CantOpenFileException, DecodeTiffException, NotEnoughtMemoryException;

    public static native boolean convertBmpTiffFd(int var0, int var1, ConverterOptions var2, IProgressListener var3) throws CantOpenFileException, DecodeTiffException, NotEnoughtMemoryException;

    public static native ImageFormat getImageType(String var0);

    public static native ImageFormat getImageTypeFd(int var0);

    static {
        System.loadLibrary("tiff");
        System.loadLibrary("tiffconverter");
    }

    public static final class ConverterOptions {
        private volatile boolean isStoped = false;
        public long availableMemory = 256000000L;
        public boolean throwExceptions = false;
        public int readTiffDirectory;
        public boolean appendTiff = false;
        public CompressionScheme compressionScheme;
        public DecodeArea inTiffDecodeArea;
        public float xResolution;
        public float yResolution;
        public ResolutionUnit resUnit = ResolutionUnit.NONE;
        public String imageDescription;
        public String software;

        public ConverterOptions() {
            this.compressionScheme = CompressionScheme.NONE;
        }

        public void stop() {
            this.isStoped = true;
        }
    }
}

