/*
 * Decompiled with CFR 0.152.
 */
package org.beyka.tiffbitmapfactory;

import android.graphics.Bitmap;
import java.io.File;
import org.beyka.tiffbitmapfactory.CompressionScheme;
import org.beyka.tiffbitmapfactory.Orientation;
import org.beyka.tiffbitmapfactory.ResolutionUnit;
import org.beyka.tiffbitmapfactory.exceptions.CantOpenFileException;
import org.beyka.tiffbitmapfactory.exceptions.NotEnoughtMemoryException;

public class TiffSaver {
    public static boolean saveBitmap(File destination, Bitmap bmp) throws CantOpenFileException, NotEnoughtMemoryException {
        return TiffSaver.saveBitmap(destination.getAbsolutePath(), bmp, new SaveOptions());
    }

    public static boolean saveBitmap(File destination, Bitmap bmp, SaveOptions options) throws CantOpenFileException {
        return TiffSaver.saveBitmap(destination.getAbsolutePath(), bmp, options);
    }

    public static boolean saveBitmap(String destinationPath, Bitmap bmp) throws CantOpenFileException {
        return TiffSaver.saveBitmap(destinationPath, bmp, new SaveOptions());
    }

    public static boolean saveBitmap(String destinationPath, Bitmap bmp, SaveOptions options) throws CantOpenFileException {
        return TiffSaver.save(destinationPath, -1, bmp, options, false);
    }

    public static boolean appendBitmap(File destination, Bitmap bmp) throws CantOpenFileException, NotEnoughtMemoryException {
        return TiffSaver.appendBitmap(destination.getAbsolutePath(), bmp, new SaveOptions());
    }

    public static boolean appendBitmap(File destination, Bitmap bmp, SaveOptions options) throws CantOpenFileException {
        return TiffSaver.appendBitmap(destination.getAbsolutePath(), bmp, options);
    }

    public static boolean appendBitmap(String destinationPath, int page, Bitmap bmp) throws CantOpenFileException {
        return TiffSaver.appendBitmap(destinationPath, bmp, new SaveOptions());
    }

    public static boolean appendBitmap(String destinationPath, Bitmap bmp, SaveOptions options) throws CantOpenFileException {
        return TiffSaver.save(destinationPath, -1, bmp, options, true);
    }

    public static boolean saveBitmap(int fileDescriptor, Bitmap bmp) throws CantOpenFileException, NotEnoughtMemoryException {
        return TiffSaver.saveBitmap(fileDescriptor, bmp, new SaveOptions());
    }

    public static boolean saveBitmap(int fileDescriptor, Bitmap bmp, SaveOptions options) throws CantOpenFileException, NotEnoughtMemoryException {
        return TiffSaver.save(null, fileDescriptor, bmp, options, false);
    }

    public static boolean appendBitmap(int fileDescriptor, Bitmap bmp) throws CantOpenFileException, NotEnoughtMemoryException {
        return TiffSaver.appendBitmap(fileDescriptor, bmp, new SaveOptions());
    }

    public static boolean appendBitmap(int fileDescriptor, Bitmap bmp, SaveOptions options) throws CantOpenFileException, NotEnoughtMemoryException {
        return TiffSaver.save(null, fileDescriptor, bmp, options, true);
    }

    private static synchronized native boolean save(String var0, int var1, Bitmap var2, SaveOptions var3, boolean var4);

    static {
        System.loadLibrary("tiff");
        System.loadLibrary("tiffsaver");
    }

    public static final class SaveOptions {
        public long inAvailableMemory = 256000000L;
        public boolean inThrowException = false;
        public CompressionScheme compressionScheme = CompressionScheme.NONE;
        public Orientation orientation = Orientation.TOP_LEFT;
        public float xResolution = 0.0f;
        public float yResolution = 0.0f;
        public ResolutionUnit resUnit = ResolutionUnit.NONE;
        public String author;
        public String copyright;
        public String imageDescription;
    }
}

