/*
 * Decompiled with CFR 0.152.
 */
package io.github.bhowell2.asynctesthelper;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class AsyncTestHelper {
    public static volatile long DEFAULT_AWAIT_TIME = 1L;
    public static volatile TimeUnit DEFAULT_AWAIT_TIME_UNIT = TimeUnit.MINUTES;
    ScheduledExecutorService scheduler;
    volatile CountDownLatch[] latches = new CountDownLatch[0];
    volatile Throwable throwable;
    volatile boolean completeImmediately = false;

    public static void retryOnFailure(int maxRetryCount, ThrowableRunnable runnable) throws Throwable {
        Throwable err = null;
        int count = maxRetryCount;
        do {
            err = null;
            try {
                runnable.run();
            }
            catch (Throwable t) {
                err = t;
            }
        } while (--count > 0 && err != null);
        if (err != null) {
            throw err;
        }
    }

    public AsyncTestHelper() {
        this(1);
    }

    public AsyncTestHelper(int executorThreadPoolSize) {
        this.scheduler = Executors.newScheduledThreadPool(executorThreadPoolSize);
    }

    public void submitToExecutor(ThrowableRunnable runnable) {
        this.scheduler.submit(this.getWrappedRunnable(runnable));
    }

    public void submitToExecutor(long delay, TimeUnit timeUnit, ThrowableRunnable runnable) {
        this.scheduler.schedule(this.getWrappedRunnable(runnable), delay, timeUnit);
    }

    public ScheduledFuture<?> schedulePeriodic(long initialDelay, long period, TimeUnit timeUnit, ThrowableRunnable runnable) {
        return this.scheduler.scheduleAtFixedRate(this.getWrappedRunnable(runnable), initialDelay, period, timeUnit);
    }

    public List<Runnable> shutdownNow() {
        return this.scheduler.shutdownNow();
    }

    public void shutdown() {
        this.scheduler.shutdown();
    }

    public boolean shutdown(long timeout, TimeUnit timeUnit) throws InterruptedException {
        this.scheduler.shutdown();
        return this.scheduler.awaitTermination(timeout, timeUnit);
    }

    public boolean isShutdown() {
        return this.scheduler.isShutdown();
    }

    public boolean isTerminated() {
        return this.scheduler.isTerminated();
    }

    public synchronized CountDownLatch getNewCountDownLatch(int count) {
        CountDownLatch latch = new CountDownLatch(count);
        CountDownLatch[] copy = Arrays.copyOf(this.latches, this.latches.length + 1);
        copy[copy.length - 1] = latch;
        this.latches = copy;
        return latch;
    }

    public boolean helperFailed() {
        return this.throwable != null;
    }

    private boolean allLatchesCleared() {
        for (int i = 0; i < this.latches.length; ++i) {
            if (this.latches[i].getCount() <= 0L) continue;
            return false;
        }
        return true;
    }

    public void fail(String message) {
        this.fail(new Exception(message));
    }

    public void fail(Throwable throwable) {
        if (this.throwable == null) {
            this.throwable = throwable;
        }
    }

    public void wrapAsyncThrowable(ThrowableRunnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable t) {
            this.fail(t);
        }
    }

    public Runnable getWrappedRunnable(ThrowableRunnable runnable) {
        return () -> this.wrapAsyncThrowable(runnable);
    }

    public <T> Callable<T> getWrappedCallable(Callable<T> callable) {
        return () -> {
            try {
                return callable.call();
            }
            catch (Throwable t) {
                this.fail(t);
                throw t;
            }
        };
    }

    public void completeImmediately() {
        this.completeImmediately = true;
    }

    public void await() throws Throwable {
        this.await(DEFAULT_AWAIT_TIME, DEFAULT_AWAIT_TIME_UNIT);
    }

    public void await(String message) throws Throwable {
        this.await(DEFAULT_AWAIT_TIME, DEFAULT_AWAIT_TIME_UNIT, message);
    }

    public void await(long timeout, TimeUnit timeUnit) throws Throwable {
        this.await(timeout, timeUnit, null);
    }

    private Callable<Boolean> makeTimeExpiredFromNowCallable(long timeout, TimeUnit timeUnit) {
        long startTime = System.nanoTime();
        return () -> timeUnit.convert(System.nanoTime() - startTime, TimeUnit.NANOSECONDS) >= timeout;
    }

    public void await(long timeout, TimeUnit timeUnit, String message) throws Throwable {
        block2: {
            message = "Await timed out after " + timeout + " " + timeUnit.name() + ". " + (message != null ? message : "");
            Callable<Boolean> awaitTimeExpired = this.makeTimeExpiredFromNowCallable(timeout, timeUnit);
            do {
                if (this.throwable != null) {
                    throw this.throwable;
                }
                if (this.allLatchesCleared() || this.completeImmediately) break block2;
            } while (!awaitTimeExpired.call().booleanValue());
            throw new TimeoutException(message);
        }
    }

    public void sleepAndThrowIfFailureOccurs(long sleepTime, TimeUnit timeUnit) throws Throwable {
        Callable<Boolean> waitTimeExpired = this.makeTimeExpiredFromNowCallable(sleepTime, timeUnit);
        while (!waitTimeExpired.call().booleanValue()) {
            if (!this.helperFailed()) continue;
            throw this.throwable;
        }
        if (this.helperFailed()) {
            throw this.throwable;
        }
    }

    @FunctionalInterface
    public static interface ThrowableRunnable {
        public void run() throws Throwable;
    }
}

