/*
 * Decompiled with CFR 0.152.
 */
package io.github.album;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import android.view.Window;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import io.github.album.AlbumConfig;
import io.github.album.Folder;
import io.github.album.FolderAdapter;
import io.github.album.LogProxy;
import io.github.album.MediaData;
import io.github.album.MediaItemAdapter;
import io.github.album.MediaLoader;
import io.github.album.Preview;
import io.github.album.QueryController;
import io.github.album.R;
import io.github.album.Session;
import io.github.album.Utils;
import io.github.album.ui.ClickHelper;
import io.github.album.ui.GridItemDecoration;
import io.github.album.ui.RoundedBottomProvider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;

public final class AlbumActivity
extends AppCompatActivity {
    private static final String TAG = "AlbumActivity";
    private static final long ANIM_DURATION = 300L;
    private TextView doneTv;
    private TextView previewTv;
    private View originalLayout;
    private ImageView originalIv;
    private TextView totalTv;
    private MediaItemAdapter itemAdapter;
    private TextView folderNameTv;
    private ImageView dropdownIv;
    private FrameLayout folderContainer;
    private RecyclerView mediaRv;
    private RecyclerView folderRv;
    private FolderAdapter folderAdapter;
    private List<Folder> data;
    private Folder currentFolder;
    private QueryController queryController;
    private boolean isFolderShowing = false;
    private AnimatorSet hideFolderSet;
    private AnimatorSet showFolderSet;
    private long onStopTime;
    private long onResumeTime;
    private Preview preview;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(AlbumConfig.style.albumLayout);
        this.setWindowStatusBarColor();
        if (!Session.ready()) {
            LogProxy.e(TAG, new Exception("Session is not ready"));
            this.finishActivity();
            return;
        }
        this.initView();
    }

    private void setWindowStatusBarColor() {
        try {
            Window window = this.getWindow();
            window.addFlags(Integer.MIN_VALUE);
            int primaryColor = Utils.getColor(AlbumConfig.style.primaryColor);
            window.setStatusBarColor(primaryColor);
            window.setNavigationBarColor(primaryColor);
            if (AlbumConfig.style.useLightStatusBar && Build.VERSION.SDK_INT >= 23) {
                View decorView = window.getDecorView();
                int visibility = decorView.getSystemUiVisibility();
                decorView.setSystemUiVisibility(visibility | 0x2000);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void confirm() {
        Session.confirm();
        this.finishActivity();
    }

    private void initView() {
        ClickHelper.listen(this.findViewById(R.id.album_close_iv), this::finishActivity);
        ClickHelper.listen(this.findViewById(R.id.album_done_tv), this::confirm);
        this.folderContainer = (FrameLayout)this.findViewById(R.id.folder_list_container);
        this.folderNameTv = (TextView)this.findViewById(R.id.folder_name_tv);
        this.dropdownIv = (ImageView)this.findViewById(R.id.album_dropdown_iv);
        this.doneTv = (TextView)this.findViewById(R.id.album_done_tv);
        this.originalLayout = this.findViewById(R.id.album_original);
        this.originalIv = (ImageView)this.findViewById(R.id.album_original_iv);
        this.totalTv = (TextView)this.findViewById(R.id.album_total_tv);
        this.previewTv = (TextView)this.findViewById(R.id.album_preview_tv);
        this.folderContainer.setOnClickListener(v -> {
            if (this.isFolderShowing) {
                this.hideFolder();
            }
        });
        ClickHelper.listen(this.findViewById(R.id.select_folder_layout), () -> {
            if (this.isFolderShowing) {
                this.hideFolder();
            } else {
                this.showFolder();
            }
        });
        ClickHelper.listen((View)this.previewTv, () -> {
            List<MediaData> selectedList = Session.result.selectedList;
            if (!selectedList.isEmpty()) {
                this.getPreview().show(new ArrayList<MediaData>(selectedList), selectedList.get(0), true);
            }
        });
        ClickHelper.listen(this.originalLayout, () -> {
            Session.result.toggleOriginalFlag();
            this.updateOriginalView();
        });
        this.mediaRv = (RecyclerView)this.findViewById(R.id.album_media_rv);
        this.mediaRv.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager((Context)this, 4));
        this.mediaRv.addItemDecoration((RecyclerView.ItemDecoration)new GridItemDecoration(4, Utils.dp2px(1.5f)));
        this.itemAdapter = new MediaItemAdapter((Context)this, new MediaItemAdapter.EventListener(){

            @Override
            public void onInsertedFront() {
                AlbumActivity.this.mediaRv.scrollToPosition(0);
            }

            @Override
            public void onItemClick(MediaData item) {
                AlbumActivity.this.getPreview().show(((AlbumActivity)AlbumActivity.this).currentFolder.mediaList, item, false);
            }

            @Override
            public void onSelectedChange() {
                AlbumActivity.this.updateViews();
            }
        });
        this.itemAdapter.setHasStableIds(true);
        this.mediaRv.setAdapter((RecyclerView.Adapter)this.itemAdapter);
        this.mediaRv.setItemAnimator(AlbumConfig.itemAnimator);
        this.updateViews();
        this.queryController = new QueryController(this::setData, this::refreshData, this::removeDeleted);
        MediaLoader.start(Session.request, this.queryController);
    }

    private void setData(List<Folder> result) {
        if (!result.isEmpty()) {
            this.data = result;
            this.updateFolder(result.get(0));
        }
    }

    private void updateFolder(Folder folder) {
        this.currentFolder = folder;
        this.folderNameTv.setText((CharSequence)folder.name);
        this.itemAdapter.update(folder.mediaList);
        if (this.isFolderShowing) {
            this.hideFolder();
        }
    }

    private void refreshData(List<Folder> result) {
        LogProxy.d(TAG, "Refresh data");
        this.update(result, true);
    }

    private void updateData(List<Folder> result) {
        LogProxy.d(TAG, "Update data");
        this.update(result, false);
    }

    private void update(List<Folder> result, boolean isRefresh) {
        List<MediaData> selectedList = Session.result.selectedList;
        boolean selectedChanged = false;
        if (!selectedList.isEmpty()) {
            List<MediaData> totalList = result.get((int)0).mediaList;
            selectedChanged = selectedList.size() < 5 ? selectedList.retainAll(totalList) : selectedList.retainAll(new HashSet<MediaData>(totalList));
        }
        this.data.clear();
        this.data.addAll(result);
        if (this.folderAdapter != null) {
            this.folderAdapter.update(this.data);
        }
        this.currentFolder = this.findMatchedFolder(result);
        this.folderNameTv.setText((CharSequence)this.currentFolder.name);
        if (isRefresh || selectedChanged || AlbumConfig.itemAnimator == null) {
            this.itemAdapter.update(this.currentFolder.mediaList);
        } else {
            this.itemAdapter.rangeUpdate(this.currentFolder.mediaList);
        }
    }

    private Folder findMatchedFolder(List<Folder> result) {
        if (this.currentFolder != null) {
            for (Folder folder : result) {
                if (!folder.name.equals(this.currentFolder.name)) continue;
                return folder;
            }
        }
        return result.get(0);
    }

    private void removeDeleted(List<MediaData> invalidList) {
        if (invalidList.isEmpty()) {
            return;
        }
        boolean selectedChanged = Session.result.selectedList.retainAll(invalidList);
        ListIterator<Folder> it = this.data.listIterator();
        while (it.hasNext()) {
            Folder folder = (Folder)it.next();
            boolean changed = folder.mediaList.removeAll(invalidList);
            if (folder == this.currentFolder && (selectedChanged || changed)) {
                this.itemAdapter.refreshUI();
            }
            if (!folder.mediaList.isEmpty() || this.data.size() <= 1) continue;
            it.remove();
        }
        if (this.currentFolder.mediaList.isEmpty()) {
            this.updateFolder(this.data.get(0));
        }
        if (this.folderAdapter != null) {
            this.folderAdapter.refreshUI();
        }
    }

    private boolean isSelected(Folder folder) {
        return this.currentFolder == folder;
    }

    private void initFolder() {
        this.folderRv = new RecyclerView((Context)this);
        this.folderRv.setBackgroundColor(this.getResources().getColor(AlbumConfig.style.primaryColor));
        this.folderRv.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.folderRv.setOutlineProvider((ViewOutlineProvider)new RoundedBottomProvider(Utils.dp2px(10.0f)));
        this.folderRv.setClipToOutline(true);
        this.folderAdapter = new FolderAdapter((Context)this, this::isSelected, this::updateFolder);
        this.folderRv.setAdapter((RecyclerView.Adapter)this.folderAdapter);
        this.folderContainer.setPadding(0, 0, 0, AlbumConfig.style.folderPaddingBottom);
        this.folderContainer.addView((View)this.folderRv, (ViewGroup.LayoutParams)new ViewGroup.MarginLayoutParams(-1, -2));
        this.folderAdapter.update(this.data);
    }

    private void showFolder() {
        if (this.folderRv == null) {
            this.folderContainer.setVisibility(4);
            this.initFolder();
            this.folderContainer.post(this::startShowAnimate);
        } else {
            this.startShowAnimate();
        }
    }

    private void startShowAnimate() {
        if (this.hasAnimation()) {
            return;
        }
        this.folderContainer.setVisibility(0);
        if (this.showFolderSet == null) {
            this.showFolderSet = new AnimatorSet();
            this.showFolderSet.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)this.folderRv, (Property)View.TRANSLATION_Y, (float[])new float[]{-this.folderRv.getHeight(), 0.0f}), ObjectAnimator.ofFloat((Object)this.dropdownIv, (Property)View.ROTATION, (float[])new float[]{0.0f, 180.0f}), ObjectAnimator.ofFloat((Object)this.folderContainer, (Property)View.ALPHA, (float[])new float[]{0.0f, 1.0f})});
            this.showFolderSet.setDuration(300L).start();
        } else {
            this.showFolderSet.start();
        }
        this.isFolderShowing = true;
    }

    private void hideFolder() {
        if (this.hasAnimation()) {
            return;
        }
        if (this.hideFolderSet == null) {
            this.hideFolderSet = new AnimatorSet();
            this.hideFolderSet.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)this.folderRv, (Property)View.TRANSLATION_Y, (float[])new float[]{0.0f, -this.folderRv.getHeight()}), ObjectAnimator.ofFloat((Object)this.dropdownIv, (Property)View.ROTATION, (float[])new float[]{180.0f, 360.0f}), ObjectAnimator.ofFloat((Object)this.folderContainer, (Property)View.ALPHA, (float[])new float[]{1.0f, 0.0f})});
            this.hideFolderSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    AlbumActivity.this.folderContainer.setVisibility(8);
                }
            });
            this.hideFolderSet.setDuration(300L).start();
        } else {
            this.hideFolderSet.start();
        }
        this.isFolderShowing = false;
    }

    private boolean hasAnimation() {
        return this.showFolderSet != null && this.showFolderSet.isStarted() || this.hideFolderSet != null && this.hideFolderSet.isStarted();
    }

    void updateOriginalView() {
        if (Session.request.enableOriginal) {
            this.originalLayout.setVisibility(0);
            if (Session.result.originalFlag) {
                this.originalIv.setImageResource(R.drawable.album_bg_original_p);
                long totalSize = Session.result.getTotalSize();
                if (totalSize == 0L) {
                    this.totalTv.setVisibility(8);
                } else {
                    this.totalTv.setVisibility(0);
                    this.totalTv.setText((CharSequence)Utils.getFormatSize(totalSize));
                }
            } else {
                this.originalIv.setImageResource(R.drawable.album_bg_original_n);
                this.totalTv.setVisibility(8);
            }
        } else if (this.originalLayout.getVisibility() != 8) {
            this.originalLayout.setVisibility(8);
        }
    }

    private void updateViews() {
        boolean enable = !Session.result.selectedList.isEmpty();
        this.doneTv.setEnabled(enable);
        this.doneTv.setText((CharSequence)Session.getDoneText());
        this.previewTv.setEnabled(enable);
        this.itemAdapter.refreshUI();
        this.updateOriginalView();
    }

    private Preview getPreview() {
        if (this.preview == null) {
            ViewGroup container = (ViewGroup)this.findViewById(R.id.album_preview_container);
            this.preview = new Preview(container, new Preview.PreviewEventListener(){

                @Override
                public void onClose() {
                    AlbumActivity.this.updateViews();
                    AlbumActivity.this.checkUpdate();
                }

                @Override
                public void onConfirm() {
                    AlbumActivity.this.confirm();
                }
            });
        }
        return this.preview;
    }

    protected void onStop() {
        super.onStop();
        this.onStopTime = System.currentTimeMillis();
    }

    protected void onResume() {
        super.onResume();
        this.onResumeTime = System.currentTimeMillis();
        if (this.preview == null || !this.preview.isShowing()) {
            this.checkUpdate();
        }
    }

    private void checkUpdate() {
        if (AlbumConfig.doResumeChecking && this.onStopTime != 0L && this.onResumeTime != 0L && this.data != null && this.queryController != null && this.queryController.isFinished && this.onResumeTime - this.onStopTime > 3000L) {
            LogProxy.d(TAG, "Start checking update");
            this.queryController = new QueryController(null, this::updateData, null);
            MediaLoader.start(Session.request, this.queryController);
        }
        this.onStopTime = 0L;
        this.onResumeTime = 0L;
    }

    public void onBackPressed() {
        if (this.preview != null && this.preview.isShowing()) {
            this.preview.close();
        } else if (this.isFolderShowing) {
            this.hideFolder();
        } else {
            this.finishActivity();
        }
    }

    protected void onDestroy() {
        this.clearSession();
        if (this.mediaRv != null) {
            this.mediaRv.setItemAnimator(null);
        }
        super.onDestroy();
    }

    private void finishActivity() {
        this.finish();
    }

    private void clearSession() {
        if (this.queryController != null) {
            this.queryController.clear();
            this.queryController = null;
        }
        Session.clear();
    }
}

