/*
 * Decompiled with CFR 0.152.
 */
package io.github.album;

import androidx.recyclerview.widget.RecyclerView;
import io.github.album.AlbumStyle;
import io.github.album.Folder;
import io.github.album.LogProxy;
import io.github.album.interfaces.AlbumLogger;
import io.github.album.interfaces.ImageLoader;
import java.util.Comparator;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public final class AlbumConfig {
    private static volatile Executor realExecutor;
    static ImageLoader imageLoader;
    static RecyclerView.ItemAnimator itemAnimator;
    static boolean doSelectedAnimation;
    static boolean doResumeChecking;
    static boolean doDeletedChecking;
    static boolean doInfoChecking;
    static AlbumStyle style;
    static Comparator<Folder> defaultFolderComparator;
    static final AlbumConfig INSTANCE;

    private AlbumConfig() {
    }

    public AlbumConfig setStyle(AlbumStyle style) {
        if (style != null) {
            AlbumConfig.style = style;
        }
        return this;
    }

    public AlbumConfig setLogger(AlbumLogger logger) {
        LogProxy.register(logger);
        return this;
    }

    public AlbumConfig setExecutor(Executor executor) {
        if (executor != null) {
            realExecutor = executor;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Executor getExecutor() {
        if (realExecutor != null) return realExecutor;
        Class<AlbumConfig> clazz = AlbumConfig.class;
        synchronized (AlbumConfig.class) {
            if (realExecutor != null) return realExecutor;
            realExecutor = Executors.newCachedThreadPool();
            // ** MonitorExit[var0] (shouldn't be in output)
            return realExecutor;
        }
    }

    public AlbumConfig setImageLoader(ImageLoader loader) {
        if (loader != null) {
            imageLoader = loader;
        }
        return this;
    }

    public AlbumConfig setDefaultFolderComparator(Comparator<Folder> comparator) {
        if (comparator != null) {
            defaultFolderComparator = comparator;
        }
        return this;
    }

    public AlbumConfig setItemAnimator(RecyclerView.ItemAnimator animator) {
        itemAnimator = animator;
        return this;
    }

    public AlbumConfig disableSelectedAnimation() {
        doSelectedAnimation = false;
        return this;
    }

    public AlbumConfig disableResumeChecking() {
        doResumeChecking = false;
        return this;
    }

    public AlbumConfig disableDeletedChecking() {
        doDeletedChecking = false;
        return this;
    }

    public AlbumConfig disableInfoChecking() {
        doInfoChecking = false;
        return this;
    }

    static {
        doSelectedAnimation = true;
        doResumeChecking = true;
        doDeletedChecking = true;
        doInfoChecking = true;
        style = new AlbumStyle();
        defaultFolderComparator = (o1, o2) -> Long.compare(o2.updatedTime, o1.updatedTime);
        INSTANCE = new AlbumConfig();
    }
}

