/*
 * Decompiled with CFR 0.152.
 */
package io.github.album;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import io.github.album.AlbumActivity;
import io.github.album.AlbumConfig;
import io.github.album.Folder;
import io.github.album.MediaData;
import io.github.album.R;
import io.github.album.Session;
import io.github.album.Utils;
import io.github.album.interfaces.AlbumListener;
import io.github.album.interfaces.MediaFilter;
import io.github.album.interfaces.ResultCallback;
import java.lang.ref.WeakReference;
import java.util.Comparator;
import java.util.List;

public final class AlbumRequest {
    private static final int MAX_SELECTED_LIMIT = 99;
    private static final int DEFAULT_SELECTED_LIMIT = 9;
    MediaFilter filter;
    Comparator<Folder> folderComparator = AlbumConfig.defaultFolderComparator;
    AlbumListener albumListener;
    OverLimitCallback overLimitCallback;
    private String allString;
    private String doneString;
    int limit = 9;
    List<MediaData> selectedList;
    boolean enableOriginal = false;
    boolean thumbnailAsBitmap = true;
    boolean previewAsBitmap = false;
    private WeakReference<Context> contextRef;

    AlbumRequest(Context context) {
        this.contextRef = new WeakReference<Context>(context);
    }

    public AlbumRequest setFilter(MediaFilter filter) {
        this.filter = filter;
        return this;
    }

    String getTag() {
        String tag = this.filter != null ? this.filter.tag() : "";
        return tag == null ? "" : tag;
    }

    public AlbumRequest setFolderComparator(Comparator<Folder> comparator) {
        if (comparator != null) {
            this.folderComparator = comparator;
        }
        return this;
    }

    public AlbumRequest setAllString(String str) {
        this.allString = str;
        return this;
    }

    String getAllString() {
        if (TextUtils.isEmpty((CharSequence)this.allString)) {
            return Utils.getString(R.string.album_all);
        }
        return this.allString;
    }

    public AlbumRequest setDoneString(String str) {
        this.doneString = str;
        return this;
    }

    String getDoneString() {
        if (TextUtils.isEmpty((CharSequence)this.doneString)) {
            return Utils.getString(R.string.album_done);
        }
        return this.doneString;
    }

    public AlbumRequest setSelectedLimit(int limit) {
        if (limit <= 0) {
            throw new IllegalArgumentException("Limit must be positive");
        }
        if (limit > 99) {
            throw new IllegalArgumentException("Limit must less or equal than 99");
        }
        this.limit = limit;
        return this;
    }

    public AlbumRequest setSelectedList(List<MediaData> mediaList) {
        this.selectedList = mediaList;
        return this;
    }

    public AlbumRequest setOverLimitCallback(OverLimitCallback callback) {
        this.overLimitCallback = callback;
        return this;
    }

    public AlbumRequest setAlbumListener(AlbumListener listener) {
        this.albumListener = listener;
        return this;
    }

    public AlbumRequest setThumbnailAsBitmap(boolean asBitmap) {
        this.thumbnailAsBitmap = asBitmap;
        return this;
    }

    public AlbumRequest setPreviewAsBitmap(boolean asBitmap) {
        this.previewAsBitmap = true;
        return this;
    }

    public AlbumRequest enableOriginal() {
        this.enableOriginal = true;
        return this;
    }

    public void start(@NonNull ResultCallback callback) {
        if (AlbumConfig.imageLoader == null) {
            throw new IllegalArgumentException("ImageLoader is null, forget to call AlbumConfig.setImageLoader()?");
        }
        Session.init(this, callback, this.selectedList);
        if (this.contextRef != null) {
            Context context = (Context)this.contextRef.get();
            if (context != null) {
                context.startActivity(new Intent(context, AlbumActivity.class));
            }
            this.contextRef = null;
        }
    }

    void clear() {
        this.filter = null;
        this.overLimitCallback = null;
        this.folderComparator = null;
        this.albumListener = null;
    }

    public static interface OverLimitCallback {
        public void onOverLimit(int var1);
    }
}

