/*
 * Decompiled with CFR 0.152.
 */
package io.github.album;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import io.github.album.AlbumConfig;
import io.github.album.Folder;
import io.github.album.MediaData;
import io.github.album.R;
import java.util.ArrayList;
import java.util.List;

final class FolderAdapter
extends RecyclerView.Adapter<FolderViewHolder> {
    private final ArrayList<Folder> data = new ArrayList();
    private final LayoutInflater inflater;
    private final StringBuilder builder = new StringBuilder();
    private final SelectedCallback callback;
    private final SelectFolderListener listener;

    FolderAdapter(Context context, SelectedCallback callback, SelectFolderListener listener) {
        this.inflater = LayoutInflater.from((Context)context);
        this.callback = callback;
        this.listener = listener;
    }

    public void update(List<Folder> list) {
        this.data.clear();
        if (list != null && !list.isEmpty()) {
            this.data.addAll(list);
        }
        this.refreshUI();
    }

    @SuppressLint(value={"NotifyDataSetChanged"})
    public void refreshUI() {
        this.notifyDataSetChanged();
    }

    @NonNull
    public FolderViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        int layout2 = AlbumConfig.style.folderItemLayout;
        FolderViewHolder holder = new FolderViewHolder(this.inflater.inflate(layout2, parent, false));
        holder.itemView.setOnClickListener(v -> {
            this.listener.onSelect(holder.folder);
            this.refreshUI();
        });
        return holder;
    }

    public void onBindViewHolder(@NonNull FolderViewHolder holder, int position) {
        Folder folder;
        holder.folder = folder = this.data.get(position);
        List<MediaData> list = folder.mediaList;
        if (list.isEmpty()) {
            holder.folderCoverIv.setImageDrawable(null);
        } else {
            AlbumConfig.imageLoader.loadThumbnail(list.get(0), holder.folderCoverIv, true);
        }
        holder.folderTitleTv.setText((CharSequence)folder.name);
        holder.mediaCountTv.setText((CharSequence)this.getCountStr(list.size()));
        holder.checkFolderIv.setVisibility(this.callback.isSelected(folder) ? 0 : 8);
    }

    private String getCountStr(int size) {
        this.builder.setLength(0);
        this.builder.append('(').append(size).append(')');
        return this.builder.toString();
    }

    public int getItemCount() {
        return this.data.size();
    }

    static interface SelectedCallback {
        public boolean isSelected(Folder var1);
    }

    static interface SelectFolderListener {
        public void onSelect(Folder var1);
    }

    public static class FolderViewHolder
    extends RecyclerView.ViewHolder {
        Folder folder;
        final ImageView folderCoverIv;
        final TextView folderTitleTv;
        final TextView mediaCountTv;
        final ImageView checkFolderIv;

        FolderViewHolder(View itemView) {
            super(itemView);
            this.folderCoverIv = (ImageView)itemView.findViewById(R.id.folder_cover_iv);
            this.folderTitleTv = (TextView)itemView.findViewById(R.id.folder_title_tv);
            this.mediaCountTv = (TextView)itemView.findViewById(R.id.media_count_tv);
            this.checkFolderIv = (ImageView)itemView.findViewById(R.id.check_folder_iv);
        }
    }
}

