/*
 * Decompiled with CFR 0.152.
 */
package io.github.album;

import android.net.Uri;
import android.os.Build;
import androidx.annotation.NonNull;
import io.github.album.AlbumConfig;
import io.github.album.LogProxy;
import io.github.album.MediaInfoReader;
import java.io.File;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;

public final class MediaData
implements Comparable<MediaData> {
    private static final String BASE_VIDEO_URI = "content://media/external/video/media/";
    private static final String BASE_IMAGE_URI = "content://media/external/images/media/";
    static final byte ROTATE_UNKNOWN = -1;
    static final byte ROTATE_NO = 0;
    static final byte ROTATE_YES = 1;
    public final boolean isVideo;
    public final int mediaId;
    public final String parent;
    public final String name;
    public final long modifiedTime;
    public String mime;
    long fileSize;
    int duration;
    int width;
    int height;
    byte rotate = (byte)-1;
    volatile boolean hadFillData = false;

    public MediaData(boolean isVideo, int mediaId, @NonNull String parent, @NonNull String name, long modifiedTime) {
        this.isVideo = isVideo;
        this.mediaId = mediaId;
        this.parent = parent;
        this.name = name;
        this.modifiedTime = modifiedTime;
    }

    public String getPath() {
        return this.parent + this.name;
    }

    public Uri getUri() {
        String baseUri = this.isVideo ? BASE_VIDEO_URI : BASE_IMAGE_URI;
        return Uri.parse((String)(baseUri + this.mediaId));
    }

    public Uri getProperUri() {
        if (Build.VERSION.SDK_INT <= 29) {
            return Uri.fromFile((File)new File(this.getPath()));
        }
        return this.getUri();
    }

    public boolean exists() {
        return new File(this.parent + this.name).exists();
    }

    public int getWidth() {
        return this.rotate != 1 ? this.width : this.height;
    }

    public int getHeight() {
        return this.rotate != 1 ? this.height : this.width;
    }

    public int getRealWidth() {
        if (this.rotate == -1 || this.width == 0 || this.height == 0) {
            this.fillData();
        }
        return this.rotate != 1 ? this.width : this.height;
    }

    public int getRealHeight() {
        if (this.rotate == -1 || this.width == 0 || this.height == 0) {
            this.fillData();
        }
        return this.rotate != 1 ? this.height : this.width;
    }

    public int getDuration() {
        if (this.isVideo && this.duration == 0) {
            this.checkData();
        }
        return this.duration;
    }

    public long getFileSize() {
        if (this.fileSize == 0L) {
            this.checkData();
        }
        return this.fileSize;
    }

    public boolean isGif() {
        return "image/gif".equals(this.mime);
    }

    void checkData() {
        if (!this.hadFillData) {
            FutureTask<Boolean> future = new FutureTask<Boolean>(this::fillData);
            try {
                AlbumConfig.getExecutor().execute(future);
                future.get(300L, TimeUnit.MILLISECONDS);
            }
            catch (Throwable ignore) {
                LogProxy.d("Album", "Fill data time out:" + this.name);
            }
        }
    }

    synchronized Boolean fillData() {
        boolean missing = false;
        if (!this.hadFillData) {
            missing = MediaInfoReader.fetchInfo(this);
            this.hadFillData = true;
        }
        return missing;
    }

    @Override
    public int compareTo(MediaData o) {
        if (this.modifiedTime == o.modifiedTime) {
            return Integer.compare(o.mediaId, this.mediaId);
        }
        return o.modifiedTime < this.modifiedTime ? -1 : 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        MediaData item = (MediaData)o;
        return this.mediaId == item.mediaId;
    }

    public int hashCode() {
        return this.mediaId;
    }
}

