/*
 * Decompiled with CFR 0.152.
 */
package io.github.album;

import android.graphics.BitmapFactory;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import android.text.TextUtils;
import androidx.exifinterface.media.ExifInterface;
import io.github.album.LogProxy;
import io.github.album.MediaData;
import io.github.album.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;

final class MediaInfoReader {
    MediaInfoReader() {
    }

    static boolean fetchInfo(MediaData data) {
        boolean missing = false;
        if (data.fileSize == 0L && Utils.hasReadPermission()) {
            try {
                data.fileSize = new File(data.getPath()).length();
                missing = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (data.fileSize == 0L) {
                return false;
            }
        }
        if ((long)data.width == 0L || (long)data.height == 0L || data.rotate == -1 || data.isVideo && data.duration == 0) {
            missing = true;
            try {
                if (data.isVideo) {
                    MediaInfoReader.fillVideoSize(data);
                } else {
                    MediaInfoReader.fillImageSize(data);
                }
            }
            catch (Throwable e) {
                LogProxy.e("Album", e);
            }
            if (data.width == 0) {
                data.width = 1080;
            }
            if (data.height == 0) {
                data.height = 1920;
            }
            if (data.rotate == -1) {
                data.rotate = 0;
            }
        }
        return missing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fillVideoSize(MediaData data) {
        MediaMetadataRetriever retriever = new MediaMetadataRetriever();
        try {
            String rotation;
            byte lastRotate;
            retriever.setDataSource(Utils.appContext, data.getProperUri());
            if (data.duration == 0) {
                try {
                    String duration = retriever.extractMetadata(9);
                    if (!TextUtils.isEmpty((CharSequence)duration)) {
                        data.duration = Integer.parseInt(duration);
                    }
                }
                catch (Exception e) {
                    LogProxy.e("Album", e);
                }
            }
            if ((lastRotate = data.rotate) == -1 && !TextUtils.isEmpty((CharSequence)(rotation = retriever.extractMetadata(24)))) {
                int o = Integer.parseInt(rotation);
                byte by = data.rotate = o == 90 || o == 270 ? (byte)1 : 0;
            }
            if (data.width == 0 || data.height == 0 || lastRotate == -1 && data.rotate == 1) {
                String width = retriever.extractMetadata(18);
                String height = retriever.extractMetadata(19);
                if (!TextUtils.isEmpty((CharSequence)width) && !TextUtils.isEmpty((CharSequence)height)) {
                    data.width = Integer.parseInt(width);
                    data.height = Integer.parseInt(height);
                }
            }
        }
        finally {
            retriever.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fillImageSize(MediaData data) throws FileNotFoundException {
        Uri uri = data.getProperUri();
        data.rotate = MediaInfoReader.isImageRotate(uri) ? (byte)1 : 0;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        InputStream inputStream = Utils.appContext.getContentResolver().openInputStream(uri);
        try {
            BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
            data.width = options.outWidth;
            data.height = options.outHeight;
        }
        finally {
            Utils.closeQuietly(inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isImageRotate(Uri uri) {
        InputStream inputStream;
        block4: {
            boolean bl;
            inputStream = null;
            try {
                ExifInterface exif;
                int orientation;
                inputStream = Utils.appContext.getContentResolver().openInputStream(uri);
                if (inputStream == null || (orientation = (exif = new ExifInterface(inputStream)).getAttributeInt("Orientation", -1)) < 5) break block4;
                bl = true;
            }
            catch (Throwable e) {
                try {
                    LogProxy.e("Album", e);
                }
                catch (Throwable throwable) {
                    Utils.closeQuietly(inputStream);
                    throw throwable;
                }
                Utils.closeQuietly(inputStream);
            }
            Utils.closeQuietly(inputStream);
            return bl;
        }
        Utils.closeQuietly(inputStream);
        return false;
    }
}

