/*
 * Decompiled with CFR 0.152.
 */
package io.github.album;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.util.Property;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import io.github.album.AlbumConfig;
import io.github.album.AlbumRequest;
import io.github.album.MediaData;
import io.github.album.R;
import io.github.album.Session;
import io.github.album.Utils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class MediaItemAdapter
extends RecyclerView.Adapter<MediaItemViewHolder> {
    private static final long ANIM_DURATION = 200L;
    private final ArrayList<MediaData> data = new ArrayList();
    private final LayoutInflater inflater;
    private final EventListener eventListener;
    private MediaData lastSelectedItem;

    MediaItemAdapter(Context context, EventListener eventListener) {
        this.inflater = LayoutInflater.from((Context)context);
        this.eventListener = eventListener;
    }

    public void update(List<MediaData> list) {
        this.data.clear();
        if (list != null && !list.isEmpty()) {
            this.data.addAll(list);
        }
        this.refreshUI();
    }

    public void rangeUpdate(List<MediaData> list) {
        if (list == null || list.isEmpty()) {
            this.update(list);
            return;
        }
        HashSet<MediaData> common = new HashSet<MediaData>(this.data);
        common.retainAll(new HashSet<MediaData>(list));
        int deletedCount = this.data.size() - common.size();
        int addedCount = list.size() - common.size();
        if (deletedCount > 0 && addedCount == 0) {
            int[] range = this.findChangedRange(this.data, common, deletedCount);
            this.data.clear();
            this.data.addAll(list);
            if (range != null) {
                this.notifyItemRangeRemoved(range[0], range[1]);
            } else {
                this.refreshUI();
            }
        } else {
            this.data.clear();
            this.data.addAll(list);
            if (deletedCount == 0 && addedCount > 0) {
                int[] range = this.findChangedRange(list, common, addedCount);
                if (range != null) {
                    this.notifyItemRangeInserted(range[0], range[1]);
                    if (range[0] == 0) {
                        this.eventListener.onInsertedFront();
                    }
                } else {
                    this.refreshUI();
                }
            } else if (deletedCount > 0 && addedCount > 0) {
                this.refreshUI();
            }
        }
    }

    private int[] findChangedRange(List<MediaData> list, Set<MediaData> common, int changeCount) {
        int n = list.size();
        int firstChanged = -1;
        for (int i = 0; i < n; ++i) {
            if (!common.contains(list.get(i))) {
                if (changeCount == 1) {
                    return new int[]{i, 1};
                }
                if (firstChanged == -1) {
                    firstChanged = i;
                    continue;
                }
                int count = i - firstChanged + 1;
                if (count != changeCount) continue;
                return new int[]{firstChanged, count};
            }
            if (firstChanged == -1) continue;
            return null;
        }
        return null;
    }

    @SuppressLint(value={"NotifyDataSetChanged"})
    public void refreshUI() {
        this.notifyDataSetChanged();
    }

    public long getItemId(int position) {
        if (position < this.data.size()) {
            return this.data.get((int)position).mediaId;
        }
        return super.getItemId(position);
    }

    @NonNull
    public MediaItemViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View itemView = this.inflater.inflate(AlbumConfig.style.albumItemLayout, parent, false);
        MediaItemViewHolder holder = new MediaItemViewHolder(itemView);
        holder.itemView.setOnClickListener(v -> this.eventListener.onItemClick(holder.item));
        holder.selectView.setOnClickListener(v -> {
            if (Session.selectItem(holder.item)) {
                if (AlbumConfig.doSelectedAnimation) {
                    this.lastSelectedItem = holder.item;
                }
                this.eventListener.onSelectedChange();
            } else {
                this.lastSelectedItem = null;
            }
        });
        return holder;
    }

    @SuppressLint(value={"SetTextI18n"})
    public void onBindViewHolder(final @NonNull MediaItemViewHolder holder, int position) {
        MediaData item;
        holder.item = item = this.data.get(position);
        AlbumRequest request = Session.request;
        AlbumConfig.imageLoader.loadThumbnail(item, holder.itemIv, request.thumbnailAsBitmap);
        if (item.isVideo) {
            holder.cameraIv.setVisibility(0);
            holder.durationTv.setVisibility(0);
            holder.durationTv.setText((CharSequence)Utils.getFormatTime(item.getDuration()));
            holder.gifIv.setVisibility(8);
        } else {
            holder.cameraIv.setVisibility(8);
            holder.durationTv.setVisibility(8);
            holder.gifIv.setVisibility(request.thumbnailAsBitmap && item.isGif() ? 0 : 8);
        }
        int selectedIndex = Session.result.selectedList.indexOf(item);
        if (selectedIndex >= 0) {
            if (request.limit > 1) {
                holder.selectTv.setBackgroundResource(R.drawable.album_bg_select_p);
                holder.selectTv.setText((CharSequence)Integer.toString(selectedIndex + 1));
            } else {
                holder.selectTv.setBackgroundResource(R.drawable.album_bg_select_radio);
            }
            holder.selectedMask.setVisibility(0);
            if (item == this.lastSelectedItem) {
                this.lastSelectedItem = null;
                ObjectAnimator.ofFloat((Object)holder.selectedMask, (Property)View.ALPHA, (float[])new float[]{0.0f, 1.0f}).setDuration(200L).start();
            }
        } else {
            holder.selectTv.setBackgroundResource(R.drawable.album_bg_select_n);
            if (request.limit > 1) {
                holder.selectTv.setText((CharSequence)"");
            }
            if (item == this.lastSelectedItem) {
                this.lastSelectedItem = null;
                AnimatorSet animatorSet = new AnimatorSet();
                animatorSet.play((Animator)ObjectAnimator.ofFloat((Object)holder.selectedMask, (Property)View.ALPHA, (float[])new float[]{1.0f, 0.0f}));
                animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        holder.selectedMask.setVisibility(8);
                    }
                });
                animatorSet.setDuration(200L).start();
            } else {
                holder.selectedMask.setVisibility(8);
            }
        }
    }

    public int getItemCount() {
        return this.data.size();
    }

    static interface EventListener {
        public void onInsertedFront();

        public void onItemClick(MediaData var1);

        public void onSelectedChange();
    }

    public static class MediaItemViewHolder
    extends RecyclerView.ViewHolder {
        MediaData item;
        final ImageView itemIv;
        final TextView selectTv;
        final View selectView;
        final ImageView cameraIv;
        final View selectedMask;
        final TextView durationTv;
        final ImageView gifIv;

        MediaItemViewHolder(View itemView) {
            super(itemView);
            this.itemIv = (ImageView)itemView.findViewById(R.id.album_item_iv);
            this.selectTv = (TextView)itemView.findViewById(R.id.album_select_tv);
            this.selectView = itemView.findViewById(R.id.album_select_v);
            this.cameraIv = (ImageView)itemView.findViewById(R.id.album_camera_iv);
            this.selectedMask = itemView.findViewById(R.id.album_selected_mask);
            this.durationTv = (TextView)itemView.findViewById(R.id.album_duration_tv);
            this.gifIv = (ImageView)itemView.findViewById(R.id.album_gif_iv);
        }
    }
}

