/*
 * Decompiled with CFR 0.152.
 */
package io.github.album;

import android.content.ContentResolver;
import android.database.Cursor;
import android.net.Uri;
import android.os.SystemClock;
import android.provider.MediaStore;
import androidx.annotation.NonNull;
import androidx.core.content.ContentResolverCompat;
import io.github.album.AlbumConfig;
import io.github.album.AlbumRequest;
import io.github.album.Folder;
import io.github.album.LogProxy;
import io.github.album.MediaData;
import io.github.album.QueryController;
import io.github.album.SerialExecutor;
import io.github.album.Session;
import io.github.album.StringPool;
import io.github.album.Utils;
import io.github.album.interfaces.MediaFilter;
import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class MediaLoader {
    private static final String TAG = "MediaLoader";
    private static final Uri CONTENT_URI = MediaStore.Files.getContentUri((String)"external");
    private static final String TYPE_SELECTION = "(media_type=3 OR media_type=1)";
    private static final int IDX_ID = 0;
    private static final int IDX_DATA = 1;
    private static final int IDX_MEDIA_TYPE = 2;
    private static final int IDX_DATE_MODIFIED = 3;
    private static final int IDX_MIME_TYPE = 4;
    private static final int IDX_DURATION = 5;
    private static final int IDX_SIZE = 6;
    private static final int IDX_WIDTH = 7;
    private static final int IDX_HEIGHT = 8;
    private static final int IDX_ORIENTATION = 9;
    private static final String[] PROJECTIONS = new String[]{"_id", "_data", "media_type", "date_modified", "mime_type", "duration", "_size", "width", "height", "orientation"};
    private static final String[] ID_PROJECTION = new String[]{"_id"};
    private static final long NEW_PICTURE_THRESHOLD = 10L;
    private static final SerialExecutor loadingExecutor = new SerialExecutor();
    private static final SerialExecutor checkingExecutor = new SerialExecutor();
    private static QueryController preloadController = null;
    private static boolean hasCache = false;
    private static boolean hadCheckedExists = false;
    private static final Set<Integer> notExistSet = new HashSet<Integer>();
    private static final Map<Integer, MediaData> mediaCache = new LinkedHashMap<Integer, MediaData>();
    private static final Map<String, List<Folder>> resultCache = new HashMap<String, List<Folder>>();
    private static final StringPool parentPool = new StringPool();
    private static final StringPool mimePool = new StringPool();

    MediaLoader() {
    }

    public static void start(AlbumRequest request, QueryController controller) {
        MediaLoader.cancelPreload();
        controller.isFinished = false;
        loadingExecutor.execute(() -> {
            if (controller.isCancelled) {
                return;
            }
            long startTime = SystemClock.uptimeMillis();
            try {
                boolean hasDataChanged;
                String tag = request.getTag();
                List<Folder> result = resultCache.get(tag);
                if (result != null && controller.dataListener != null) {
                    MediaLoader.logTime("Post data with cache in ", startTime);
                    controller.postData(result);
                }
                if (!hasCache) {
                    MediaLoader.load(controller);
                    hasCache = true;
                    hasDataChanged = true;
                    MediaLoader.logTime("Load time:", startTime);
                } else {
                    hasDataChanged = MediaLoader.refresh(controller);
                    MediaLoader.logTime("Refresh time:", startTime);
                }
                if (controller.isCancelled) {
                    return;
                }
                if (result == null || controller.dataListener != null || controller.updateListener != null) {
                    if (result == null) {
                        List<Folder> newResult = MediaLoader.makeResult(request);
                        MediaLoader.logTime("Post new data in ", startTime);
                        resultCache.put(tag, newResult);
                        controller.postData(newResult);
                    } else if (hasDataChanged) {
                        List<Folder> newResult = MediaLoader.makeResult(request);
                        if (!result.equals(newResult)) {
                            MediaLoader.logTime("Post update data in ", startTime);
                            resultCache.put(tag, newResult);
                            controller.postUpdate(newResult);
                        }
                    } else {
                        LogProxy.d(TAG, "No data changed");
                    }
                }
                LogProxy.d(TAG, "Media count:" + mediaCache.size());
                if (AlbumConfig.doDeletedChecking && !hadCheckedExists && !controller.isCancelled) {
                    MediaLoader.checkExists(controller, startTime);
                }
            }
            catch (Throwable t) {
                LogProxy.e(TAG, t);
            }
            finally {
                controller.isFinished = true;
            }
        });
    }

    private static void logTime(String action, long startTime) {
        long queryTime = SystemClock.uptimeMillis() - startTime;
        LogProxy.d(TAG, action + queryTime + "ms");
    }

    public static void preload() {
        QueryController controller;
        if (hasCache) {
            return;
        }
        preloadController = controller = new QueryController(null, null, null);
        loadingExecutor.execute(() -> {
            if (hasCache || controller.isCancelled) {
                preloadController = null;
                return;
            }
            long startTime = SystemClock.uptimeMillis();
            try {
                MediaLoader.load(controller);
                hasCache = true;
                if (AlbumConfig.doDeletedChecking && !hadCheckedExists && !controller.isCancelled) {
                    MediaLoader.checkExists(controller, startTime);
                }
            }
            catch (Throwable t) {
                LogProxy.e(TAG, t);
            }
            finally {
                preloadController = null;
            }
        });
    }

    private static void cancelPreload() {
        QueryController t = preloadController;
        if (t != null) {
            t.isCancelled = true;
        }
    }

    public static void clearCache() {
        if (Session.result == null) {
            loadingExecutor.execute(() -> {
                hasCache = false;
                mediaCache.clear();
                resultCache.clear();
            });
        }
    }

    private static void load(QueryController controller) {
        List<MediaData> list = MediaLoader.query(null);
        if (list != null && !list.isEmpty()) {
            for (MediaData item : list) {
                mediaCache.put(item.mediaId, item);
            }
            MediaLoader.checkInfo(list, controller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean refresh(QueryController controller) {
        HashSet newIdSet;
        ArrayList<Integer> ids;
        Cursor cursor = ContentResolverCompat.query((ContentResolver)Utils.appContext.getContentResolver(), (Uri)CONTENT_URI, (String[])ID_PROJECTION, (String)TYPE_SELECTION, null, null, null);
        if (cursor == null) {
            return false;
        }
        try {
            int count = cursor.getCount();
            ids = new ArrayList<Integer>(count);
            while (cursor.moveToNext()) {
                int id2 = cursor.getInt(0);
                if (!MediaLoader.exist(id2)) continue;
                ids.add(id2);
            }
        }
        finally {
            Utils.closeQuietly((Closeable)cursor);
        }
        Set<Integer> cacheSet = mediaCache.keySet();
        if (cacheSet.equals(newIdSet = new HashSet(ids))) {
            return false;
        }
        cacheSet.retainAll(newIdSet);
        ids.removeAll(cacheSet);
        if (!ids.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            if (ids.size() < 50) {
                MediaLoader.queryByIds(ids, builder, controller);
            } else {
                ArrayList<Integer> idList = new ArrayList<Integer>();
                for (Integer id3 : ids) {
                    idList.add(id3);
                    if (idList.size() != 50) continue;
                    MediaLoader.queryByIds(idList, builder, controller);
                    idList.clear();
                }
                if (!idList.isEmpty()) {
                    MediaLoader.queryByIds(idList, builder, controller);
                }
            }
        }
        return true;
    }

    private static void queryByIds(List<Integer> idList, StringBuilder builder, QueryController controller) {
        builder.setLength(0);
        if (idList.size() == 1) {
            builder.append("_id").append('=').append(idList.get(0));
        } else {
            builder.append("_id").append(" in (");
            for (Integer id2 : idList) {
                builder.append(id2).append(',');
            }
            builder.setCharAt(builder.length() - 1, ')');
        }
        List<MediaData> list = MediaLoader.query(builder.toString());
        if (list != null && !list.isEmpty()) {
            ArrayList<MediaData> excludeList = new ArrayList<MediaData>();
            long currentTimeSeconds = System.currentTimeMillis() / 1000L;
            for (MediaData item : list) {
                if (currentTimeSeconds - item.modifiedTime < 10L) {
                    if (item.exists()) {
                        mediaCache.put(item.mediaId, item);
                        continue;
                    }
                    excludeList.add(item);
                    continue;
                }
                mediaCache.put(item.mediaId, item);
            }
            if (!excludeList.isEmpty()) {
                list.removeAll(excludeList);
            }
            MediaLoader.checkInfo(list, controller);
        }
    }

    private static void checkInfo(List<MediaData> list, QueryController controller) {
        if (!AlbumConfig.doInfoChecking || list.isEmpty()) {
            return;
        }
        checkingExecutor.execute(() -> {
            int count = 0;
            long t0 = SystemClock.uptimeMillis();
            ArrayList<MediaData> emptyFileMedias = new ArrayList<MediaData>();
            for (MediaData item : list) {
                if (!item.fillData().booleanValue()) continue;
                if (item.fileSize <= 0L && Utils.hasReadPermission()) {
                    emptyFileMedias.add(item);
                }
                ++count;
            }
            if (!emptyFileMedias.isEmpty()) {
                MediaLoader.markEmptyMedia(emptyFileMedias, controller);
                LogProxy.d(TAG, "There are " + emptyFileMedias.size() + " empty files");
            }
            long t1 = SystemClock.uptimeMillis();
            LogProxy.d(TAG, "Check info finish, missing count:" + count + ", used:" + (t1 - t0) + "ms");
        });
    }

    private static void markEmptyMedia(List<MediaData> emptyFileList, QueryController controller) {
        loadingExecutor.execute(() -> {
            for (MediaData item : emptyFileList) {
                notExistSet.add(item.mediaId);
            }
            if (!controller.isCancelled) {
                controller.postInvalid(emptyFileList);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<MediaData> query(String idSelection) {
        ArrayList<MediaData> list;
        String selection = idSelection != null ? idSelection : TYPE_SELECTION;
        Cursor cursor = ContentResolverCompat.query((ContentResolver)Utils.appContext.getContentResolver(), (Uri)CONTENT_URI, (String[])PROJECTIONS, (String)selection, null, null, null);
        if (cursor == null) {
            return null;
        }
        try {
            int count = cursor.getCount();
            list = new ArrayList<MediaData>(count);
            while (cursor.moveToNext()) {
                int id2 = cursor.getInt(0);
                String path = cursor.getString(1);
                if (!MediaLoader.exist(id2) || path == null || path.isEmpty()) continue;
                int type = cursor.getInt(2);
                long time = cursor.getLong(3);
                String parent = parentPool.getOrAdd(Utils.getParentPath(path));
                String name = Utils.getFileName(path);
                boolean isVideo = type == 3;
                MediaData item = new MediaData(isVideo, id2, parent, name, time);
                item.mime = mimePool.getOrAdd(cursor.getString(4));
                item.duration = isVideo ? cursor.getInt(5) : 0;
                item.fileSize = cursor.getLong(6);
                item.width = cursor.getInt(7);
                item.height = cursor.getInt(8);
                if (!cursor.isNull(9)) {
                    int orientation = cursor.getInt(9);
                    item.rotate = orientation == 90 || orientation == 270 ? (byte)1 : 0;
                }
                list.add(item);
            }
        }
        finally {
            Utils.closeQuietly((Closeable)cursor);
        }
        return list;
    }

    private static List<Folder> makeResult(AlbumRequest request) {
        MediaFilter filter = request.filter;
        ArrayList<MediaData> totalList = new ArrayList<MediaData>(mediaCache.size());
        if (filter == null) {
            totalList.addAll(mediaCache.values());
        } else {
            for (MediaData mediaData : mediaCache.values()) {
                if (!filter.accept(mediaData)) continue;
                totalList.add(mediaData);
            }
        }
        Collections.sort(totalList);
        HashMap<String, ArrayList<MediaData>> groupMap = new HashMap<String, ArrayList<MediaData>>();
        for (MediaData item : totalList) {
            String parent = item.parent;
            ArrayList<MediaData> subList = (ArrayList<MediaData>)groupMap.get(parent);
            if (subList == null) {
                subList = new ArrayList<MediaData>();
                groupMap.put(parent, subList);
            }
            subList.add(item);
        }
        ArrayList<Folder> arrayList = new ArrayList<Folder>(groupMap.size() + 1);
        for (Map.Entry entry : groupMap.entrySet()) {
            String folderName = Utils.getFileName((String)entry.getKey());
            arrayList.add(new Folder(folderName, (List)entry.getValue()));
        }
        Collections.sort(arrayList, request.folderComparator);
        arrayList.add(0, new Folder(request.getAllString(), totalList));
        return arrayList;
    }

    private static void checkExists(QueryController controller, long startTime) {
        if (mediaCache.isEmpty()) {
            return;
        }
        ArrayList<MediaData> notExistsList = new ArrayList<MediaData>();
        if (Utils.hasReadPermission()) {
            HashMap<String, ArrayList<MediaData>> groupMap = new HashMap<String, ArrayList<MediaData>>();
            for (MediaData mediaData : mediaCache.values()) {
                String parent = mediaData.parent;
                ArrayList<MediaData> subList = (ArrayList<MediaData>)groupMap.get(parent);
                if (subList == null) {
                    subList = new ArrayList<MediaData>();
                    groupMap.put(parent, subList);
                }
                subList.add(mediaData);
            }
            for (Map.Entry entry : groupMap.entrySet()) {
                MediaLoader.checkDirectory(controller, (String)entry.getKey(), (List)entry.getValue(), notExistsList);
                if (!controller.isCancelled) continue;
                return;
            }
        } else {
            ArrayList<MediaData> totalList = new ArrayList<MediaData>(mediaCache.size());
            totalList.addAll(mediaCache.values());
            MediaLoader.checkList(controller, totalList, notExistsList);
        }
        if (controller.isCancelled) {
            return;
        }
        hadCheckedExists = true;
        long time = SystemClock.uptimeMillis() - startTime;
        LogProxy.d(TAG, "Check exists finish, used:" + time + "ms, deleted count:" + notExistsList.size());
        controller.postInvalid(notExistsList);
    }

    private static void checkDirectory(QueryController controller, String parentPath, List<MediaData> subList, List<MediaData> notExistsList) {
        if (subList.isEmpty()) {
            return;
        }
        File parentFile = new File(parentPath);
        String[] fileNameArray = parentFile.list();
        if (fileNameArray == null || fileNameArray.length == 0) {
            MediaLoader.checkList(controller, subList, notExistsList);
        } else {
            HashSet<String> nameSet = new HashSet<String>(Arrays.asList(fileNameArray));
            long currentTimeSeconds = System.currentTimeMillis() / 1000L;
            for (MediaData item : subList) {
                if (currentTimeSeconds - item.modifiedTime < 10L || nameSet.contains(item.name)) continue;
                if (controller.isCancelled) {
                    return;
                }
                if (item.exists()) continue;
                notExistsList.add(item);
                MediaLoader.markDeleted(item);
            }
        }
    }

    private static void checkList(QueryController controller, List<MediaData> list, List<MediaData> deletedSet) {
        long currentTimeSeconds = System.currentTimeMillis() / 1000L;
        for (MediaData item : list) {
            if (controller.isCancelled) {
                return;
            }
            if (currentTimeSeconds - item.modifiedTime <= 10L || item.exists()) continue;
            deletedSet.add(item);
            MediaLoader.markDeleted(item);
        }
    }

    private static boolean exist(int mediaId) {
        return notExistSet.isEmpty() || !notExistSet.contains(mediaId);
    }

    private static void markDeleted(MediaData item) {
        Integer mediaId = item.mediaId;
        notExistSet.add(mediaId);
        mediaCache.remove(mediaId);
    }

    public static interface DataListener {
        public void onReady(@NonNull List<Folder> var1);
    }

    public static interface UpdateListener {
        public void onUpdate(@NonNull List<Folder> var1);
    }

    public static interface DeletedListener {
        public void onDelete(@NonNull List<MediaData> var1);
    }
}

