/*
 * Decompiled with CFR 0.152.
 */
package io.github.album;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.graphics.Rect;
import android.util.Property;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import io.github.album.AlbumConfig;
import io.github.album.LogProxy;
import io.github.album.MediaData;
import io.github.album.PreviewItem;
import io.github.album.R;
import io.github.album.SelectedAdapter;
import io.github.album.Session;
import io.github.album.Utils;
import io.github.album.ui.ClickHelper;
import io.github.album.ui.PreviewViewPager;
import java.util.List;

final class Preview {
    private static final String TAG = "Preview";
    private static final long ANIM_DURATION = 250L;
    private static final int SELECTED_HORIZON_MARGIN = Utils.dp2px(5.0f);
    private static final int SELECTED_VERTICAL_MARGIN = Utils.dp2px(13.5f);
    final ViewGroup previewContainer;
    final PreviewEventListener eventListener;
    final View.OnClickListener previewClickListener;
    private View rootView;
    private PreviewHolder holder;
    private int currentIndex = 0;
    private SelectedAdapter selectedAdapter;
    List<MediaData> mediaList;
    private boolean isTitleShowing = true;
    private AnimatorSet hideTitleSet;
    private AnimatorSet showTitleSet;
    private boolean selectedPreview = false;

    Preview(ViewGroup container, PreviewEventListener listener) {
        this.previewContainer = container;
        this.eventListener = listener;
        this.previewClickListener = v -> this.toggleTitle();
    }

    Context getContext() {
        return this.previewContainer.getContext();
    }

    void show(List<MediaData> mediaList, MediaData item, boolean selectedPreview) {
        if (this.rootView == null) {
            this.selectedPreview = selectedPreview;
            this.initView(mediaList, item);
        }
    }

    void close() {
        if (this.rootView != null) {
            this.previewContainer.setVisibility(8);
            this.previewContainer.removeView(this.rootView);
            this.rootView = null;
            this.holder = null;
            this.mediaList = null;
            this.selectedAdapter = null;
            this.hideTitleSet = null;
            this.showTitleSet = null;
            this.eventListener.onClose();
        }
    }

    boolean isShowing() {
        return this.rootView != null;
    }

    private void initView(List<MediaData> list, MediaData item) {
        View root;
        this.mediaList = list;
        this.currentIndex = Math.max(this.mediaList.indexOf(item), 0);
        this.rootView = root = LayoutInflater.from((Context)this.previewContainer.getContext()).inflate(AlbumConfig.style.previewLayout, this.previewContainer, false);
        this.previewContainer.setVisibility(0);
        this.previewContainer.addView(root);
        this.holder = new PreviewHolder(root);
        root.setOnClickListener(v -> LogProxy.d(TAG, "click preview"));
        this.initPager();
        this.initViews();
        this.initSelectedRv();
        ClickHelper.listen(this.holder.backIv, this::close);
        ClickHelper.listen((View)this.holder.doneTv, this.eventListener::onConfirm);
        ClickHelper.listen(this.holder.originalLayout, () -> {
            Session.result.toggleOriginalFlag();
            this.holder.updateOriginalView();
        });
        ClickHelper.listen(this.holder.selectLayout, () -> {
            MediaData mediaData;
            if (this.currentIndex < this.mediaList.size() && Session.selectItem(mediaData = this.mediaList.get(this.currentIndex)) && Session.request.limit > 1) {
                if (Session.result.selectedList.isEmpty()) {
                    this.holder.selectedRv.setVisibility(8);
                } else {
                    this.holder.selectedRv.setVisibility(0);
                }
                this.selectedAdapter.updateMedia(mediaData, this.selectedPreview);
            }
            this.holder.updateOriginalView();
            this.holder.updateSelectIv();
            this.holder.updateDoneTv();
            this.selectedAdapter.refreshUI();
        });
    }

    private void initViews() {
        this.holder.updateOriginalView();
        this.holder.updateSelectIv();
        this.holder.updateDoneTv();
        this.holder.updateTitleTv();
    }

    private void initSelectedRv() {
        this.selectedAdapter = new SelectedAdapter(this, Session.result.selectedList);
        this.selectedAdapter.setHasStableIds(true);
        RecyclerView selectedRv = this.holder.selectedRv;
        selectedRv.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext(), 0, false));
        selectedRv.addItemDecoration(new RecyclerView.ItemDecoration(){

            public void getItemOffsets(@NonNull Rect outRect, @NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
                outRect.left = SELECTED_HORIZON_MARGIN;
                outRect.right = SELECTED_HORIZON_MARGIN;
                outRect.top = SELECTED_VERTICAL_MARGIN;
            }
        });
        selectedRv.setAdapter((RecyclerView.Adapter)this.selectedAdapter);
        if (Session.result.selectedList.isEmpty() || Session.request.limit == 1) {
            selectedRv.setVisibility(8);
        } else {
            selectedRv.setVisibility(0);
        }
        this.holder.scrollSelectRv();
    }

    private void toggleTitle() {
        if (this.hasAnimation()) {
            return;
        }
        if (this.isTitleShowing) {
            this.hideTitle();
        } else {
            this.showTitle();
        }
    }

    private void showTitle() {
        if (this.showTitleSet == null) {
            int headerHeight = this.holder.previewHeader.getHeight();
            int bottomHeight = this.holder.previewBottom.getHeight();
            this.showTitleSet = new AnimatorSet();
            this.showTitleSet.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)this.holder.previewHeader, (Property)View.TRANSLATION_Y, (float[])new float[]{-headerHeight, 0.0f}), ObjectAnimator.ofFloat((Object)this.holder.previewBottom, (Property)View.TRANSLATION_Y, (float[])new float[]{bottomHeight, 0.0f}), ObjectAnimator.ofFloat((Object)this.holder.selectedRv, (Property)View.ALPHA, (float[])new float[]{0.0f, 1.0f})});
            this.showTitleSet.setDuration(250L).start();
        } else {
            this.showTitleSet.start();
        }
        this.isTitleShowing = true;
    }

    private void hideTitle() {
        if (this.hideTitleSet == null) {
            int headerHeight = this.holder.previewHeader.getHeight();
            int bottomHeight = this.holder.previewBottom.getHeight();
            this.hideTitleSet = new AnimatorSet();
            this.hideTitleSet.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)this.holder.previewHeader, (Property)View.TRANSLATION_Y, (float[])new float[]{0.0f, -headerHeight}), ObjectAnimator.ofFloat((Object)this.holder.previewBottom, (Property)View.TRANSLATION_Y, (float[])new float[]{0.0f, bottomHeight}), ObjectAnimator.ofFloat((Object)this.holder.selectedRv, (Property)View.ALPHA, (float[])new float[]{1.0f, 0.0f})});
            this.hideTitleSet.setDuration(250L).start();
        } else {
            this.hideTitleSet.start();
        }
        this.isTitleShowing = false;
    }

    private boolean hasAnimation() {
        return this.showTitleSet != null && this.showTitleSet.isStarted() || this.hideTitleSet != null && this.hideTitleSet.isStarted();
    }

    void selectedItem(MediaData item) {
        int index = this.mediaList.indexOf(item);
        if (index < 0) {
            return;
        }
        this.currentIndex = index;
        this.holder.viewPager.setCurrentItem(index);
    }

    MediaData getCurrentMedia() {
        return this.currentIndex < this.mediaList.size() ? this.mediaList.get(this.currentIndex) : null;
    }

    private void initPager() {
        PagerAdapter adapter = this.getPagerAdapter();
        PreviewViewPager viewPager = this.holder.viewPager;
        viewPager.setAdapter(adapter);
        viewPager.setCurrentItem(this.currentIndex);
        viewPager.setOffscreenPageLimit(2);
        viewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                if (Preview.this.currentIndex != position && Preview.this.currentIndex < Preview.this.mediaList.size()) {
                    MediaData preMedia = Preview.this.mediaList.get(Preview.this.currentIndex);
                    int childCount = ((Preview)Preview.this).holder.viewPager.getChildCount();
                    for (int i = 0; i < childCount; ++i) {
                        View view = ((Preview)Preview.this).holder.viewPager.getChildAt(i);
                        Object tag = view.getTag();
                        if (!(tag instanceof PreviewItem.VideoItem)) continue;
                        PreviewItem.VideoItem videoItem = (PreviewItem.VideoItem)tag;
                        if (videoItem.media != preMedia) continue;
                        videoItem.pause();
                        break;
                    }
                }
                Preview.this.currentIndex = position;
                Preview.this.holder.updateSelectIv();
                Preview.this.holder.updateTitleTv();
                Preview.this.selectedAdapter.refreshUI();
                Preview.this.holder.scrollSelectRv();
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
    }

    private PagerAdapter getPagerAdapter() {
        return new PagerAdapter(){

            @NonNull
            public Object instantiateItem(@NonNull ViewGroup container, int position) {
                MediaData media = Preview.this.mediaList.get(position);
                PreviewItem viewItem = Preview.this.getViewItem(container, media);
                container.addView(viewItem.root);
                viewItem.show();
                viewItem.onClickListener = Preview.this.previewClickListener;
                return viewItem;
            }

            public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
                if (object instanceof PreviewItem) {
                    PreviewItem item = (PreviewItem)object;
                    container.removeView(item.root);
                    item.root.setTag(null);
                }
            }

            public int getCount() {
                return Preview.this.mediaList.size();
            }

            public boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
                if (object instanceof PreviewItem) {
                    return view == ((PreviewItem)object).root;
                }
                return view == object;
            }
        };
    }

    private PreviewItem getViewItem(ViewGroup container, MediaData media) {
        if (media.isVideo) {
            return new PreviewItem.VideoItem(container, media);
        }
        return new PreviewItem.ImageItem(container, media);
    }

    private class PreviewHolder {
        final View previewHeader;
        final View previewBottom;
        final View backIv;
        final TextView titleTv;
        final View originalLayout;
        final ImageView originalIv;
        final TextView totalTv;
        final TextView doneTv;
        final View selectLayout;
        final ImageView selectIv;
        final RecyclerView selectedRv;
        final PreviewViewPager viewPager;

        PreviewHolder(View root) {
            this.previewHeader = root.findViewById(R.id.album_preview_header);
            this.previewBottom = root.findViewById(R.id.album_preview_bottom);
            this.backIv = root.findViewById(R.id.album_preview_back_iv);
            this.titleTv = (TextView)root.findViewById(R.id.album_preview_title_tv);
            this.originalLayout = root.findViewById(R.id.album_preview_original);
            this.originalIv = (ImageView)this.originalLayout.findViewById(R.id.album_preview_original_iv);
            this.totalTv = (TextView)this.originalLayout.findViewById(R.id.album_preview_total_tv);
            this.doneTv = (TextView)root.findViewById(R.id.album_preview_done_tv);
            this.selectLayout = root.findViewById(R.id.album_preview_select);
            this.selectIv = (ImageView)root.findViewById(R.id.album_preview_select_iv);
            this.selectedRv = (RecyclerView)root.findViewById(R.id.album_preview_selected_rv);
            this.viewPager = (PreviewViewPager)root.findViewById(R.id.album_preview_view_pager);
        }

        void updateOriginalView() {
            if (Session.request.enableOriginal) {
                if (this.originalLayout.getVisibility() != 0) {
                    this.originalLayout.setVisibility(0);
                }
                if (Session.result.originalFlag) {
                    this.originalIv.setImageResource(R.drawable.album_bg_original_p);
                    long totalSize = Session.result.getTotalSize();
                    if (totalSize == 0L) {
                        this.totalTv.setVisibility(8);
                    } else {
                        this.totalTv.setVisibility(0);
                        this.totalTv.setText((CharSequence)Utils.getFormatSize(totalSize));
                    }
                } else {
                    this.originalIv.setImageResource(R.drawable.album_bg_original_n);
                    this.totalTv.setVisibility(8);
                }
            } else if (this.originalLayout.getVisibility() != 8) {
                this.originalLayout.setVisibility(8);
            }
        }

        void updateSelectIv() {
            if (Preview.this.currentIndex >= Preview.this.mediaList.size()) {
                return;
            }
            List<MediaData> selectedList = Session.result.selectedList;
            MediaData mediaData = Preview.this.mediaList.get(Preview.this.currentIndex);
            boolean isSelected = selectedList.contains(mediaData);
            if (isSelected) {
                this.selectIv.setImageResource(R.drawable.album_preview_select_p);
            } else {
                this.selectIv.setImageResource(R.drawable.album_preview_select_n);
            }
        }

        void updateDoneTv() {
            this.doneTv.setEnabled(!Session.result.selectedList.isEmpty());
            this.doneTv.setText((CharSequence)Session.getDoneText());
        }

        void updateTitleTv() {
            String text = "" + (Preview.this.currentIndex + 1) + '/' + Preview.this.mediaList.size();
            this.titleTv.setText((CharSequence)text);
        }

        void scrollSelectRv() {
            if (Preview.this.currentIndex >= Preview.this.mediaList.size()) {
                return;
            }
            List<MediaData> selectedList = Session.result.selectedList;
            MediaData mediaData = Preview.this.mediaList.get(Preview.this.currentIndex);
            int position = selectedList.indexOf(mediaData);
            if (position > -1) {
                this.selectedRv.scrollToPosition(position);
            }
        }
    }

    static interface PreviewEventListener {
        public void onClose();

        public void onConfirm();
    }
}

