/*
 * Decompiled with CFR 0.152.
 */
package io.github.album;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.net.Uri;
import android.view.LayoutInflater;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.appcompat.widget.AppCompatImageView;
import com.davemorrissey.labs.subscaleview.ImageSource;
import com.davemorrissey.labs.subscaleview.SubsamplingScaleImageView;
import com.github.chrisbanes.photoview.PhotoView;
import io.github.album.AlbumConfig;
import io.github.album.AlbumRequest;
import io.github.album.MediaData;
import io.github.album.R;
import io.github.album.Session;
import io.github.album.VideoPlayer;

abstract class PreviewItem {
    final MediaData media;
    final View root;
    View.OnClickListener onClickListener;

    PreviewItem(ViewGroup container, MediaData media) {
        this.media = media;
        int layoutId = media.isVideo ? R.layout.album_video_item : R.layout.album_image_item;
        this.root = LayoutInflater.from((Context)container.getContext()).inflate(layoutId, container, false);
    }

    void performClick() {
        if (this.onClickListener != null) {
            this.onClickListener.onClick(null);
        }
    }

    abstract void show();

    static class VideoItem
    extends PreviewItem {
        private final TextureView textureView;
        private final AppCompatImageView playView;
        private VideoPlayer player;
        private Surface videoSurface;
        private VideoState state = VideoState.INIT;

        VideoItem(ViewGroup container, MediaData media) {
            super(container, media);
            this.textureView = (TextureView)this.root.findViewById(R.id.texture_view);
            this.playView = (AppCompatImageView)this.root.findViewById(R.id.play_view);
            this.playView.setOnClickListener(v -> this.togglePlay());
            this.root.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

                public void onViewAttachedToWindow(View v) {
                }

                public void onViewDetachedFromWindow(View v) {
                    this.release();
                }
            });
            this.textureView.setOnClickListener(v -> this.onClick());
            this.root.setOnClickListener(v -> this.onClick());
        }

        private void onClick() {
            this.performClick();
            this.showPlayView();
        }

        private void showPlayView() {
            if (this.playView.getAlpha() != 1.0f) {
                this.playView.setAlpha(1.0f);
            }
        }

        private void togglePlay() {
            if (this.state == VideoState.READY && this.player != null) {
                if (this.player.isPlaying()) {
                    this.player.pause();
                } else {
                    this.player.play();
                }
            }
        }

        void pause() {
            if (this.state == VideoState.READY && this.player != null && this.player.isPlaying()) {
                this.player.pause();
                this.showPlayView();
            }
        }

        private void release() {
            if (this.state != VideoState.RELEASE) {
                this.state = VideoState.RELEASE;
                if (this.player != null) {
                    this.player.release();
                }
                if (this.videoSurface != null) {
                    this.videoSurface.release();
                }
                this.videoSurface = null;
                this.player = null;
            }
        }

        @Override
        void show() {
            if (this.state == VideoState.INIT) {
                this.player = new VideoPlayer(this.media.getProperUri(), this.getListener());
                this.textureView.setVisibility(0);
                this.textureView.setSurfaceTextureListener(new TextureView.SurfaceTextureListener(){

                    public void onSurfaceTextureAvailable(@NonNull SurfaceTexture surface, int width, int height) {
                        videoSurface = new Surface(surface);
                        player.setSurface(videoSurface);
                        player.prepare();
                    }

                    public void onSurfaceTextureSizeChanged(@NonNull SurfaceTexture surface, int width, int height) {
                    }

                    public boolean onSurfaceTextureDestroyed(@NonNull SurfaceTexture surface) {
                        return false;
                    }

                    public void onSurfaceTextureUpdated(@NonNull SurfaceTexture surface) {
                    }
                });
                this.root.setTag((Object)this);
            }
        }

        private void setSurfaceSize(TextureView textureView, int width, int height) {
            int rootWidth = this.root.getWidth();
            int rootHeight = this.root.getHeight();
            if (width <= 0 || height <= 0 || rootWidth <= 0 || rootHeight <= 0) {
                return;
            }
            float ratio = (float)width / (float)height;
            int targetHeight = (int)((float)rootWidth / ratio);
            if (targetHeight > rootHeight) {
                targetHeight = rootHeight;
            }
            int targetWidth = (int)((float)targetHeight * ratio);
            ViewGroup.LayoutParams params = textureView.getLayoutParams();
            if (params.width != targetWidth || params.height != targetHeight) {
                params.width = targetWidth;
                params.height = targetHeight;
                textureView.setLayoutParams(params);
            }
        }

        private VideoPlayer.VideoPlayerListener getListener() {
            return new VideoPlayer.VideoPlayerListener(){

                @Override
                public void onStart() {
                    playView.setImageResource(R.drawable.album_pause);
                    playView.setAlpha(0.0f);
                }

                @Override
                public void onStop() {
                    playView.setImageResource(R.drawable.album_play);
                    playView.setAlpha(1.0f);
                }

                @Override
                public void onPrepared(int width, int height) {
                    this.setSurfaceSize(textureView, width, height);
                    playView.setAlpha(1.0f);
                    state = VideoState.READY;
                }

                @Override
                public void onVideoSizeChanged(int width, int height) {
                    this.setSurfaceSize(textureView, width, height);
                }

                @Override
                public void onCompletion() {
                    player.seekTo(0);
                    player.pause();
                    this.showPlayView();
                }

                @Override
                public void onError() {
                    playView.setVisibility(8);
                }
            };
        }
    }

    static enum VideoState {
        INIT,
        READY,
        RELEASE;

    }

    static class ImageItem
    extends PreviewItem {
        ImageItem(ViewGroup container, MediaData media) {
            super(container, media);
        }

        @Override
        void show() {
            PhotoView photoView = (PhotoView)this.root.findViewById(R.id.album_item_photo_view);
            SubsamplingScaleImageView scaleImageView = (SubsamplingScaleImageView)this.root.findViewById(R.id.album_item_scale_iv);
            int width = this.media.getWidth();
            int height = this.media.getHeight();
            if (width < 2048 && height < 2048) {
                photoView.setVisibility(0);
                scaleImageView.setVisibility(8);
                AlbumRequest request = Session.request;
                if (request != null) {
                    AlbumConfig.imageLoader.loadPreview(this.media, (ImageView)photoView, request.previewAsBitmap);
                }
            } else {
                scaleImageView.setExecutor(AlbumConfig.getExecutor());
                photoView.setVisibility(8);
                scaleImageView.setOrientation(-1);
                scaleImageView.setVisibility(0);
                scaleImageView.setImage(ImageSource.uri((Uri)this.media.getProperUri()));
            }
            photoView.setOnClickListener(v -> this.performClick());
            scaleImageView.setOnClickListener(v -> this.performClick());
            this.root.setOnClickListener(v -> this.performClick());
        }
    }
}

