/*
 * Decompiled with CFR 0.152.
 */
package io.github.album;

import androidx.annotation.NonNull;
import io.github.album.Folder;
import io.github.album.MediaData;
import io.github.album.MediaLoader;
import io.github.album.Utils;
import java.util.List;

final class QueryController {
    volatile MediaLoader.DataListener dataListener;
    volatile MediaLoader.UpdateListener updateListener;
    volatile MediaLoader.DeletedListener deletedListener;
    volatile boolean isCancelled = false;
    volatile boolean isFinished = false;

    QueryController(MediaLoader.DataListener dataListener, MediaLoader.UpdateListener updateListener, MediaLoader.DeletedListener deletedListener) {
        this.dataListener = dataListener;
        this.updateListener = updateListener;
        this.deletedListener = deletedListener;
    }

    void postData(@NonNull List<Folder> result) {
        if (this.dataListener != null) {
            Utils.uiHandler.post(() -> {
                MediaLoader.DataListener listener = this.dataListener;
                if (listener != null) {
                    listener.onReady(result);
                }
            });
        }
    }

    void postUpdate(@NonNull List<Folder> result) {
        if (this.updateListener != null) {
            Utils.uiHandler.post(() -> {
                MediaLoader.UpdateListener listener = this.updateListener;
                if (listener != null) {
                    listener.onUpdate(result);
                }
            });
        }
    }

    void postInvalid(@NonNull List<MediaData> invalidList) {
        if (this.deletedListener != null && !invalidList.isEmpty()) {
            Utils.uiHandler.post(() -> {
                MediaLoader.DeletedListener listener = this.deletedListener;
                if (listener != null) {
                    listener.onDelete(invalidList);
                }
            });
        }
    }

    void clear() {
        this.isCancelled = true;
        this.dataListener = null;
        this.updateListener = null;
        this.deletedListener = null;
    }
}

