/*
 * Decompiled with CFR 0.152.
 */
package io.github.album;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import io.github.album.AlbumConfig;
import io.github.album.AlbumRequest;
import io.github.album.MediaData;
import io.github.album.Preview;
import io.github.album.R;
import io.github.album.Session;
import java.util.ArrayList;
import java.util.List;

class SelectedAdapter
extends RecyclerView.Adapter<SelectedViewHolder> {
    private final ArrayList<MediaData> data = new ArrayList();
    private final LayoutInflater inflater;
    private final Preview preview;

    SelectedAdapter(Preview preview, List<MediaData> list) {
        this.inflater = LayoutInflater.from((Context)preview.getContext());
        this.preview = preview;
        this.data.addAll(list);
    }

    void updateMedia(MediaData mediaData, boolean selectedPreview) {
        if (selectedPreview) {
            if (!this.data.contains(mediaData)) {
                this.data.add(mediaData);
            }
        } else {
            List<MediaData> selectedList = Session.result.selectedList;
            if (selectedList.contains(mediaData)) {
                if (!this.data.contains(mediaData)) {
                    this.data.add(mediaData);
                }
            } else {
                this.data.remove(mediaData);
            }
        }
    }

    @SuppressLint(value={"NotifyDataSetChanged"})
    public void refreshUI() {
        this.notifyDataSetChanged();
    }

    public long getItemId(int position) {
        if (position < this.data.size()) {
            return this.data.get((int)position).mediaId;
        }
        return super.getItemId(position);
    }

    @NonNull
    public SelectedViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View itemView = this.inflater.inflate(R.layout.album_selected_media_item, parent, false);
        SelectedViewHolder holder = new SelectedViewHolder(itemView);
        holder.itemView.setOnClickListener(v -> this.preview.selectedItem(holder.item));
        return holder;
    }

    public void onBindViewHolder(@NonNull SelectedViewHolder holder, int position) {
        MediaData item;
        holder.item = item = this.data.get(position);
        AlbumRequest request = Session.request;
        AlbumConfig.imageLoader.loadThumbnail(item, holder.itemIv, request.thumbnailAsBitmap);
        if (item.isVideo) {
            holder.cameraIv.setVisibility(0);
        } else {
            holder.cameraIv.setVisibility(8);
        }
        List<MediaData> selectedList = Session.result.selectedList;
        if (selectedList.contains(item)) {
            holder.itemMask.setVisibility(8);
        } else {
            holder.itemMask.setVisibility(0);
        }
        if (item == this.preview.getCurrentMedia()) {
            holder.itemFrame.setVisibility(0);
        } else {
            holder.itemFrame.setVisibility(4);
        }
    }

    public int getItemCount() {
        return this.data.size();
    }

    static class SelectedViewHolder
    extends RecyclerView.ViewHolder {
        MediaData item;
        final ImageView itemIv;
        final View itemMask;
        final View itemFrame;
        final ImageView cameraIv;

        SelectedViewHolder(View itemView) {
            super(itemView);
            this.itemIv = (ImageView)itemView.findViewById(R.id.album_selected_item_iv);
            this.itemMask = itemView.findViewById(R.id.album_selected_item_mask);
            this.itemFrame = itemView.findViewById(R.id.album_selected_item_frame);
            this.cameraIv = (ImageView)itemView.findViewById(R.id.album_selected_item_camera);
        }
    }
}

