/*
 * Decompiled with CFR 0.152.
 */
package io.github.album;

import io.github.album.AlbumConfig;
import java.util.ArrayDeque;
import java.util.concurrent.Executor;

final class SerialExecutor
implements Executor {
    final ArrayDeque<Runnable> mTasks = new ArrayDeque();
    Runnable mActive;

    SerialExecutor() {
    }

    @Override
    public synchronized void execute(Runnable r) {
        this.mTasks.offer(() -> {
            try {
                r.run();
            }
            finally {
                this.scheduleNext();
            }
        });
        if (this.mActive == null) {
            this.scheduleNext();
        }
    }

    private synchronized void scheduleNext() {
        this.mActive = this.mTasks.poll();
        if (this.mActive != null) {
            AlbumConfig.getExecutor().execute(this.mActive);
        }
    }
}

