/*
 * Decompiled with CFR 0.152.
 */
package io.github.album;

import io.github.album.AlbumRequest;
import io.github.album.AlbumResult;
import io.github.album.MediaData;
import io.github.album.R;
import io.github.album.Utils;
import io.github.album.interfaces.ResultCallback;
import java.util.List;

final class Session {
    static AlbumRequest request;
    static AlbumResult result;
    static boolean hadConfirm;
    private static ResultCallback resultCallback;

    Session() {
    }

    static void init(AlbumRequest req, ResultCallback callback, List<MediaData> selectedList) {
        request = req;
        resultCallback = callback;
        result = new AlbumResult();
        if (selectedList != null) {
            Session.result.selectedList.addAll(selectedList);
        }
        hadConfirm = false;
    }

    static boolean ready() {
        return request != null && resultCallback != null;
    }

    static void clear() {
        if (request != null) {
            if (Session.request.albumListener != null) {
                Session.request.albumListener.onAlbumClose(hadConfirm);
            }
            request.clear();
            request = null;
            resultCallback = null;
            result = null;
        }
    }

    static void confirm() {
        hadConfirm = true;
        if (resultCallback != null) {
            resultCallback.onResult(result);
        }
    }

    static boolean selectItem(MediaData item) {
        List<MediaData> selectedList = Session.result.selectedList;
        if (Session.request.limit == 1) {
            if (!selectedList.isEmpty()) {
                boolean isSameItem = selectedList.get(0) == item;
                selectedList.clear();
                if (!isSameItem) {
                    selectedList.add(item);
                }
            } else {
                selectedList.add(item);
            }
        } else {
            int index = selectedList.indexOf(item);
            if (index >= 0) {
                selectedList.remove(item);
            } else {
                if (selectedList.size() >= Session.request.limit) {
                    Session.handleOverLimit(Session.request.limit);
                    return false;
                }
                selectedList.add(item);
            }
        }
        return true;
    }

    static String getDoneText() {
        int limit = Session.request.limit;
        String doneString = request.getDoneString();
        if (limit == 1) {
            return doneString;
        }
        int selectedCount = Session.result.selectedList.size();
        if (selectedCount == 0) {
            return doneString;
        }
        return doneString + '(' + selectedCount + '/' + limit + ')';
    }

    private static void handleOverLimit(int limit) {
        AlbumRequest.OverLimitCallback callback = Session.request.overLimitCallback;
        if (callback != null) {
            callback.onOverLimit(limit);
        } else {
            Utils.showTips(Utils.getString(R.string.album_selected_over_limit));
        }
    }
}

