/*
 * Decompiled with CFR 0.152.
 */
package io.github.album;

final class StringPool {
    int size;
    Node[] nodes = new Node[16];

    StringPool() {
    }

    public String getOrAdd(String key) {
        Node node;
        if (key == null || key.isEmpty()) {
            return "";
        }
        int h = key.hashCode();
        if ((node = this.find(h ^= h >>> 16, key)) != null) {
            return node.key;
        }
        this.add(h, key);
        return key;
    }

    private Node find(int hash, String key) {
        int n = this.nodes.length;
        Node node = this.nodes[hash & n - 1];
        while (node != null) {
            if (node.hash == hash && node.key.equals(key)) {
                return node;
            }
            node = node.next;
        }
        return null;
    }

    private void add(int hash, String key) {
        int index;
        int n = this.nodes.length;
        if (this.size >= (n >> 2) * 3) {
            int newCapacity = n << 1;
            int mask = newCapacity - 1;
            Node[] newArray = new Node[newCapacity];
            Node[] nodeArray = this.nodes;
            int n2 = nodeArray.length;
            for (int i = 0; i < n2; ++i) {
                Node value;
                Node node = value = nodeArray[i];
                while (node != null) {
                    Node prev = node;
                    node = prev.next;
                    int i2 = prev.hash & mask;
                    prev.next = newArray[i2];
                    newArray[i2] = prev;
                }
            }
            this.nodes = newArray;
            index = hash & mask;
        } else {
            index = hash & n - 1;
        }
        Node head = this.nodes[index];
        this.nodes[index] = new Node(hash, key, head);
        ++this.size;
    }

    private static class Node {
        final int hash;
        final String key;
        Node next;

        Node(int hash, String key, Node next) {
            this.hash = hash;
            this.key = key;
            this.next = next;
        }
    }
}

