/*
 * Decompiled with CFR 0.152.
 */
package io.github.album;

import android.content.Context;
import android.content.res.Resources;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.widget.Toast;
import androidx.annotation.ColorRes;
import androidx.annotation.StringRes;
import java.io.Closeable;
import java.io.File;

final class Utils {
    private static final long K = 1024L;
    private static final long M = 0x100000L;
    private static final long G = 0x40000000L;
    static final Handler uiHandler = new Handler(Looper.getMainLooper());
    private static final int UNKNOWN = -1;
    private static final int NO = 0;
    private static final int YES = 1;
    private static int hasPermission = -1;
    static Context appContext;
    private static float density;

    Utils() {
    }

    private static float getDensity() {
        if (density == 1.0f) {
            density = Resources.getSystem().getDisplayMetrics().density;
        }
        return density;
    }

    static boolean hasReadPermission() {
        if (hasPermission == -1) {
            boolean flag = false;
            try {
                File externalRoot = Environment.getExternalStorageDirectory();
                flag = externalRoot != null && externalRoot.canRead();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            hasPermission = flag ? 1 : 0;
        }
        return hasPermission == 1;
    }

    static int dp2px(float dp) {
        return Math.round(dp * Utils.getDensity());
    }

    static String getFormatTime(long millis) {
        long s = millis / 1000L;
        long min = s / 60L;
        long sec = s % 60L;
        StringBuilder builder = new StringBuilder();
        builder.append(min).append(':');
        if (s < 10L) {
            builder.append('0');
        }
        builder.append(sec);
        return builder.toString();
    }

    static String getFormatSize(long size) {
        if (size >= 0x40000000L) {
            return (size >> 30) + "GB";
        }
        if (size >= 0x100000L) {
            return (size >> 20) + "MB";
        }
        if (size >= 1024L) {
            return (size >> 10) + "KB";
        }
        return size + "B";
    }

    static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static String getString(@StringRes int resId) {
        return appContext.getString(resId);
    }

    static int getColor(@ColorRes int resId) {
        return appContext.getResources().getColor(resId);
    }

    static void showTips(String tips) {
        Toast.makeText((Context)appContext, (CharSequence)tips, (int)0).show();
    }

    static String getParentPath(String path) {
        int end = path.lastIndexOf(47);
        return end <= 0 ? "" : path.substring(0, end + 1);
    }

    static String getFileName(String path) {
        int length = path.length();
        if (length == 0) {
            return "";
        }
        if (path.charAt(length - 1) == '/') {
            int index = path.lastIndexOf(47, length - 2);
            return index <= 0 ? path.substring(0, length - 1) : path.substring(index + 1, length - 1);
        }
        int index = path.lastIndexOf(47);
        return index <= 0 ? path : path.substring(index + 1);
    }

    static {
        density = 1.0f;
    }
}

