/*
 * Decompiled with CFR 0.152.
 */
package io.github.album;

import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.view.Surface;
import androidx.annotation.NonNull;
import io.github.album.LogProxy;
import io.github.album.Utils;

final class VideoPlayer {
    private static final String TAG = "VideoPlayer";
    private static final int MSG_INIT = 1;
    private static final int MSG_SET_SURFACE = 2;
    private static final int MSG_START = 3;
    private static final int MSG_PAUSE = 4;
    private static final int MSG_RELEASE = 5;
    private static final int MSG_SEEK = 6;
    private static final int MSG_PREPARE = 7;
    private final HandlerThread worker = new HandlerThread("video-player");
    private final Handler workHandler;
    private MediaPlayer mediaPlayer;
    private static final Handler uiHandler = new Handler(Looper.getMainLooper());
    private final VideoPlayerListener playerListener;
    private boolean isPrepared = false;

    VideoPlayer(Object source, VideoPlayerListener listener) {
        this.playerListener = listener;
        this.worker.start();
        this.workHandler = new Handler(this.worker.getLooper()){

            public void handleMessage(@NonNull Message msg) {
                try {
                    VideoPlayer.this.handleMsg(msg);
                }
                catch (Exception e) {
                    LogProxy.e(VideoPlayer.TAG, e);
                }
            }
        };
        Message msg = Message.obtain((Handler)this.workHandler);
        msg.what = 1;
        msg.obj = source;
        msg.sendToTarget();
    }

    public void setSurface(Surface surface) {
        Message msg = Message.obtain((Handler)this.workHandler);
        msg.what = 2;
        msg.obj = surface;
        msg.sendToTarget();
    }

    public void prepare() {
        Message msg = Message.obtain((Handler)this.workHandler);
        msg.what = 7;
        msg.sendToTarget();
    }

    public void play() {
        Message msg = Message.obtain((Handler)this.workHandler);
        msg.what = 3;
        msg.sendToTarget();
    }

    public void pause() {
        Message msg = Message.obtain((Handler)this.workHandler);
        msg.what = 4;
        msg.sendToTarget();
    }

    public void release() {
        Message msg = Message.obtain((Handler)this.workHandler);
        msg.what = 5;
        msg.sendToTarget();
    }

    public void seekTo(int mills) {
        Message msg = Message.obtain((Handler)this.workHandler);
        msg.what = 6;
        msg.obj = mills;
        msg.sendToTarget();
    }

    public boolean isPlaying() {
        return this.mediaPlayer != null && this.mediaPlayer.isPlaying();
    }

    private void handleMsg(@NonNull Message msg) {
        switch (msg.what) {
            case 1: {
                this.initPlayer(msg.obj);
                break;
            }
            case 2: {
                try {
                    Surface surface = (Surface)msg.obj;
                    if (surface == null || !surface.isValid()) {
                        LogProxy.d(TAG, "Surface invalid");
                        return;
                    }
                    this.mediaPlayer.setSurface(surface);
                }
                catch (Exception e) {
                    LogProxy.e(TAG, e);
                }
                break;
            }
            case 7: {
                this.preparePlayer();
                this.mediaPlayer.seekTo(0);
                break;
            }
            case 3: {
                this.preparePlayer();
                if (!this.isPrepared) break;
                this.mediaPlayer.start();
                uiHandler.post(this.playerListener::onStart);
                break;
            }
            case 4: {
                this.mediaPlayer.pause();
                uiHandler.post(this.playerListener::onStop);
                break;
            }
            case 5: {
                this.isPrepared = false;
                this.mediaPlayer.stop();
                this.worker.quit();
                this.mediaPlayer.release();
                break;
            }
            case 6: {
                int mills = (Integer)msg.obj;
                if (Build.VERSION.SDK_INT >= 26) {
                    this.mediaPlayer.seekTo((long)mills, 3);
                    break;
                }
                this.mediaPlayer.seekTo(mills);
                break;
            }
        }
    }

    private void preparePlayer() {
        if (!this.isPrepared) {
            try {
                this.mediaPlayer.prepare();
                this.isPrepared = true;
            }
            catch (Exception e) {
                LogProxy.e(TAG, e);
            }
        }
    }

    private void initPlayer(Object source) {
        MediaPlayer player = new MediaPlayer();
        player.setOnPreparedListener(mp -> uiHandler.post(() -> this.playerListener.onPrepared(mp.getVideoWidth(), mp.getVideoHeight())));
        player.setOnCompletionListener(mp -> uiHandler.post(this.playerListener::onCompletion));
        player.setOnErrorListener((mp, what, extra) -> {
            uiHandler.post(this.playerListener::onError);
            return true;
        });
        player.setOnVideoSizeChangedListener((mp, width, height) -> uiHandler.post(() -> this.playerListener.onVideoSizeChanged(width, height)));
        player.setScreenOnWhilePlaying(true);
        try {
            if (source instanceof Uri) {
                player.setDataSource(Utils.appContext, (Uri)source);
            } else if (source instanceof String) {
                player.setDataSource((String)source);
            } else {
                LogProxy.e(TAG, new Exception("Invalid source:" + source));
            }
        }
        catch (Exception e) {
            LogProxy.e(TAG, e);
        }
        this.mediaPlayer = player;
    }

    static interface VideoPlayerListener {
        public void onStart();

        public void onStop();

        public void onPrepared(int var1, int var2);

        public void onVideoSizeChanged(int var1, int var2);

        public void onCompletion();

        public void onError();
    }
}

