/*
 * Decompiled with CFR 0.152.
 */
package io.github.album.ui;

import android.view.View;
import androidx.annotation.NonNull;

public class ClickHelper {
    private static final long DELAY_LIMIT = 400L;
    private static final int LAST_CLICK_TAG = 1123460103;

    public static void listen(@NonNull View view, @NonNull ClickListener listener) {
        view.setOnClickListener(v -> {
            long passedTime;
            long now = System.currentTimeMillis();
            Object lastClickTime = v.getTag(1123460103);
            if (lastClickTime == null) {
                listener.onClick();
            } else if (lastClickTime instanceof Long && (passedTime = now - (Long)lastClickTime) > 400L) {
                listener.onClick();
            }
            v.setTag(1123460103, (Object)now);
        });
    }

    public static interface ClickListener {
        public void onClick();
    }
}

