/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.impl;

import com.binance.connector.client.WebsocketStreamClient;
import com.binance.connector.client.exceptions.BinanceConnectorException;
import com.binance.connector.client.utils.ParameterChecker;
import com.binance.connector.client.utils.RequestBuilder;
import com.binance.connector.client.utils.UrlBuilder;
import com.binance.connector.client.utils.WebSocketCallback;
import com.binance.connector.client.utils.WebSocketConnection;
import com.binance.connector.client.utils.httpclient.WebSocketStreamHttpClientSingleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebsocketStreamClientImpl
implements WebsocketStreamClient {
    private static final Logger logger = LoggerFactory.getLogger(WebsocketStreamClientImpl.class);
    private static final OkHttpClient client = WebSocketStreamHttpClientSingleton.getHttpClient();
    private final String baseUrl;
    private final Map<Integer, WebSocketConnection> connections = new HashMap<Integer, WebSocketConnection>();
    private final WebSocketCallback noopCallback;

    public WebsocketStreamClientImpl() {
        this.noopCallback = msg -> {};
        this.baseUrl = "wss://stream.binance.com:9443";
    }

    public WebsocketStreamClientImpl(String baseUrl) {
        this.noopCallback = msg -> {};
        this.baseUrl = baseUrl;
    }

    @Override
    public int aggTradeStream(String symbol, WebSocketCallback callback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        return this.aggTradeStream(symbol.toLowerCase(), this.noopCallback, callback, this.noopCallback, this.noopCallback);
    }

    @Override
    public int aggTradeStream(String symbol, WebSocketCallback onOpenCallback, WebSocketCallback onMessageCallback, WebSocketCallback onClosingCallback, WebSocketCallback onFailureCallback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        Request request = RequestBuilder.buildWebsocketRequest(String.format("%s/ws/%s@aggTrade", this.baseUrl, symbol.toLowerCase()));
        return this.createConnection(onOpenCallback, onMessageCallback, onClosingCallback, onFailureCallback, request);
    }

    @Override
    public int tradeStream(String symbol, WebSocketCallback callback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        return this.tradeStream(symbol.toLowerCase(), this.noopCallback, callback, this.noopCallback, this.noopCallback);
    }

    @Override
    public int tradeStream(String symbol, WebSocketCallback onOpenCallback, WebSocketCallback onMessageCallback, WebSocketCallback onClosingCallback, WebSocketCallback onFailureCallback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        Request request = RequestBuilder.buildWebsocketRequest(String.format("%s/ws/%s@trade", this.baseUrl, symbol.toLowerCase()));
        return this.createConnection(onOpenCallback, onMessageCallback, onClosingCallback, onFailureCallback, request);
    }

    @Override
    public int klineStream(String symbol, String interval, WebSocketCallback callback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        return this.klineStream(symbol.toLowerCase(), interval, this.noopCallback, callback, this.noopCallback, this.noopCallback);
    }

    @Override
    public int klineStream(String symbol, String interval, WebSocketCallback onOpenCallback, WebSocketCallback onMessageCallback, WebSocketCallback onClosingCallback, WebSocketCallback onFailureCallback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        Request request = RequestBuilder.buildWebsocketRequest(String.format("%s/ws/%s@kline_%s", this.baseUrl, symbol.toLowerCase(), interval));
        return this.createConnection(onOpenCallback, onMessageCallback, onClosingCallback, onFailureCallback, request);
    }

    @Override
    public int miniTickerStream(String symbol, WebSocketCallback callback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        return this.miniTickerStream(symbol.toLowerCase(), this.noopCallback, callback, this.noopCallback, this.noopCallback);
    }

    @Override
    public int miniTickerStream(String symbol, WebSocketCallback onOpenCallback, WebSocketCallback onMessageCallback, WebSocketCallback onClosingCallback, WebSocketCallback onFailureCallback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        Request request = RequestBuilder.buildWebsocketRequest(String.format("%s/ws/%s@miniTicker", this.baseUrl, symbol.toLowerCase()));
        return this.createConnection(onOpenCallback, onMessageCallback, onClosingCallback, onFailureCallback, request);
    }

    @Override
    public int allMiniTickerStream(WebSocketCallback callback) {
        return this.allMiniTickerStream(this.noopCallback, callback, this.noopCallback, this.noopCallback);
    }

    @Override
    public int allMiniTickerStream(WebSocketCallback onOpenCallback, WebSocketCallback onMessageCallback, WebSocketCallback onClosingCallback, WebSocketCallback onFailureCallback) {
        Request request = RequestBuilder.buildWebsocketRequest(String.format("%s/ws/!miniTicker@arr", this.baseUrl));
        return this.createConnection(onOpenCallback, onMessageCallback, onClosingCallback, onFailureCallback, request);
    }

    @Override
    public int symbolTicker(String symbol, WebSocketCallback callback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        return this.symbolTicker(symbol.toLowerCase(), this.noopCallback, callback, this.noopCallback, this.noopCallback);
    }

    @Override
    public int symbolTicker(String symbol, WebSocketCallback onOpenCallback, WebSocketCallback onMessageCallback, WebSocketCallback onClosingCallback, WebSocketCallback onFailureCallback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        Request request = RequestBuilder.buildWebsocketRequest(String.format("%s/ws/%s@ticker", this.baseUrl, symbol.toLowerCase()));
        return this.createConnection(onOpenCallback, onMessageCallback, onClosingCallback, onFailureCallback, request);
    }

    @Override
    public int allTickerStream(WebSocketCallback callback) {
        return this.allTickerStream(this.noopCallback, callback, this.noopCallback, this.noopCallback);
    }

    @Override
    public int allTickerStream(WebSocketCallback onOpenCallback, WebSocketCallback onMessageCallback, WebSocketCallback onClosingCallback, WebSocketCallback onFailureCallback) {
        Request request = RequestBuilder.buildWebsocketRequest(String.format("%s/ws/!ticker@arr", this.baseUrl));
        return this.createConnection(onOpenCallback, onMessageCallback, onClosingCallback, onFailureCallback, request);
    }

    @Override
    public int rollingWindowTicker(String symbol, String windowSize, WebSocketCallback callback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        ParameterChecker.checkParameterType(symbol, String.class, "windowSize");
        ArrayList<String> allowedWindowSize = new ArrayList<String>(){
            {
                this.add("1h");
                this.add("4h");
            }
        };
        if (!allowedWindowSize.contains(windowSize)) {
            throw new BinanceConnectorException(String.format("\"%s\" is not a valid window size.", windowSize));
        }
        return this.rollingWindowTicker(symbol.toLowerCase(), windowSize, this.noopCallback, callback, this.noopCallback, this.noopCallback);
    }

    @Override
    public int rollingWindowTicker(String symbol, String windowSize, WebSocketCallback onOpenCallback, WebSocketCallback onMessageCallback, WebSocketCallback onClosingCallback, WebSocketCallback onFailureCallback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        ParameterChecker.checkParameterType(symbol, String.class, "windowSize");
        ArrayList<String> allowedWindowSize = new ArrayList<String>(){
            {
                this.add("1h");
                this.add("4h");
            }
        };
        if (!allowedWindowSize.contains(windowSize)) {
            throw new BinanceConnectorException(String.format("\"%s\" is not a valid window size.", windowSize));
        }
        Request request = RequestBuilder.buildWebsocketRequest(String.format("%s/ws/%s@ticker_%s", this.baseUrl, symbol.toLowerCase(), windowSize));
        return this.createConnection(onOpenCallback, onMessageCallback, onClosingCallback, onFailureCallback, request);
    }

    @Override
    public int allRollingWindowTicker(String windowSize, WebSocketCallback callback) {
        ParameterChecker.checkParameterType(windowSize, String.class, "windowSize");
        ArrayList<String> allowedWindowSize = new ArrayList<String>(){
            {
                this.add("1h");
                this.add("4h");
            }
        };
        if (!allowedWindowSize.contains(windowSize.toLowerCase())) {
            throw new BinanceConnectorException(String.format("\"%s\" is not a valid window size.", windowSize.toLowerCase()));
        }
        return this.allRollingWindowTicker(windowSize.toLowerCase(), this.noopCallback, callback, this.noopCallback, this.noopCallback);
    }

    @Override
    public int allRollingWindowTicker(String windowSize, WebSocketCallback onOpenCallback, WebSocketCallback onMessageCallback, WebSocketCallback onClosingCallback, WebSocketCallback onFailureCallback) {
        ParameterChecker.checkParameterType(windowSize, String.class, "windowSize");
        Request request = RequestBuilder.buildWebsocketRequest(String.format("%s/ws/!ticker_%s@arr", this.baseUrl, windowSize.toLowerCase()));
        return this.createConnection(onOpenCallback, onMessageCallback, onClosingCallback, onFailureCallback, request);
    }

    @Override
    public int bookTicker(String symbol, WebSocketCallback callback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        return this.bookTicker(symbol.toLowerCase(), this.noopCallback, callback, this.noopCallback, this.noopCallback);
    }

    @Override
    public int bookTicker(String symbol, WebSocketCallback onOpenCallback, WebSocketCallback onMessageCallback, WebSocketCallback onClosingCallback, WebSocketCallback onFailureCallback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        Request request = RequestBuilder.buildWebsocketRequest(String.format("%s/ws/%s@bookTicker", this.baseUrl, symbol.toLowerCase()));
        return this.createConnection(onOpenCallback, onMessageCallback, onClosingCallback, onFailureCallback, request);
    }

    @Override
    public int partialDepthStream(String symbol, int levels, int speed, WebSocketCallback callback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        return this.partialDepthStream(symbol.toLowerCase(), levels, speed, this.noopCallback, callback, this.noopCallback, this.noopCallback);
    }

    @Override
    public int partialDepthStream(String symbol, int levels, int speed, WebSocketCallback onOpenCallback, WebSocketCallback onMessageCallback, WebSocketCallback onClosingCallback, WebSocketCallback onFailureCallback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        Request request = RequestBuilder.buildWebsocketRequest(String.format("%s/ws/%s@depth%s@%sms", this.baseUrl, symbol.toLowerCase(), levels, speed));
        return this.createConnection(onOpenCallback, onMessageCallback, onClosingCallback, onFailureCallback, request);
    }

    @Override
    public int diffDepthStream(String symbol, int speed, WebSocketCallback callback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        return this.diffDepthStream(symbol.toLowerCase(), speed, this.noopCallback, callback, this.noopCallback, this.noopCallback);
    }

    @Override
    public int diffDepthStream(String symbol, int speed, WebSocketCallback onOpenCallback, WebSocketCallback onMessageCallback, WebSocketCallback onClosingCallback, WebSocketCallback onFailureCallback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        Request request = RequestBuilder.buildWebsocketRequest(String.format("%s/ws/%s@depth@%sms", this.baseUrl, symbol.toLowerCase(), speed));
        return this.createConnection(onOpenCallback, onMessageCallback, onClosingCallback, onFailureCallback, request);
    }

    @Override
    public int listenUserStream(String listenKey, WebSocketCallback callback) {
        return this.listenUserStream(listenKey, this.noopCallback, callback, this.noopCallback, this.noopCallback);
    }

    @Override
    public int listenUserStream(String listenKey, WebSocketCallback onOpenCallback, WebSocketCallback onMessageCallback, WebSocketCallback onClosingCallback, WebSocketCallback onFailureCallback) {
        Request request = RequestBuilder.buildWebsocketRequest(String.format("%s/ws/%s", this.baseUrl, listenKey));
        return this.createConnection(onOpenCallback, onMessageCallback, onClosingCallback, onFailureCallback, request);
    }

    @Override
    public int combineStreams(ArrayList<String> streams, WebSocketCallback callback) {
        return this.combineStreams(streams, this.noopCallback, callback, this.noopCallback, this.noopCallback);
    }

    @Override
    public int combineStreams(ArrayList<String> streams, WebSocketCallback onOpenCallback, WebSocketCallback onMessageCallback, WebSocketCallback onClosingCallback, WebSocketCallback onFailureCallback) {
        String url = UrlBuilder.buildStreamUrl(String.format("%s/stream", this.baseUrl), streams);
        Request request = RequestBuilder.buildWebsocketRequest(url);
        return this.createConnection(onOpenCallback, onMessageCallback, onClosingCallback, onFailureCallback, request);
    }

    @Override
    public void closeConnection(int connectionId) {
        if (this.connections.containsKey(connectionId)) {
            this.connections.get(connectionId).close();
            logger.info("Closing Connection ID {}", (Object)connectionId);
            this.connections.remove(connectionId);
        } else {
            logger.info("Connection ID {} does not exist!", (Object)connectionId);
        }
    }

    @Override
    public void closeAllConnections() {
        if (!this.connections.isEmpty()) {
            logger.info("Closing {} connections(s)", (Object)this.connections.size());
            Iterator<Map.Entry<Integer, WebSocketConnection>> iter = this.connections.entrySet().iterator();
            while (iter.hasNext()) {
                WebSocketConnection connection = iter.next().getValue();
                connection.close();
                iter.remove();
            }
        }
        if (this.connections.isEmpty()) {
            client.dispatcher().executorService().shutdown();
            logger.info("All connections are closed!");
        }
    }

    private int createConnection(WebSocketCallback onOpenCallback, WebSocketCallback onMessageCallback, WebSocketCallback onClosingCallback, WebSocketCallback onFailureCallback, Request request) {
        WebSocketConnection connection = new WebSocketConnection(onOpenCallback, onMessageCallback, onClosingCallback, onFailureCallback, request, client);
        connection.connect();
        int connectionId = connection.getConnectionId();
        this.connections.put(connectionId, connection);
        return connectionId;
    }
}

